"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findEntityDefinitions = findEntityDefinitions;
var _lodash = require("lodash");
var _saved_objects = require("../../saved_objects");
var _generate_history_ingest_pipeline_id = require("./ingest_pipeline/generate_history_ingest_pipeline_id");
var _generate_latest_ingest_pipeline_id = require("./ingest_pipeline/generate_latest_ingest_pipeline_id");
var _generate_history_transform_id = require("./transform/generate_history_transform_id");
var _generate_latest_transform_id = require("./transform/generate_latest_transform_id");
var _built_in = require("./built_in");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findEntityDefinitions({
  soClient,
  esClient,
  builtIn,
  id,
  page = 1,
  perPage = 10
}) {
  const filter = (0, _lodash.compact)([typeof builtIn === 'boolean' ? `${_saved_objects.SO_ENTITY_DEFINITION_TYPE}.attributes.id:(${_built_in.BUILT_IN_ID_PREFIX}*)` : undefined, id ? `${_saved_objects.SO_ENTITY_DEFINITION_TYPE}.attributes.id:(${id})` : undefined]).join(' AND ');
  const response = await soClient.find({
    type: _saved_objects.SO_ENTITY_DEFINITION_TYPE,
    filter,
    page,
    perPage
  });
  return Promise.all(response.saved_objects.map(async ({
    attributes
  }) => {
    const state = await getEntityDefinitionState(esClient, attributes);
    return {
      ...attributes,
      state
    };
  }));
}
async function getEntityDefinitionState(esClient, definition) {
  const historyIngestPipelineId = (0, _generate_history_ingest_pipeline_id.generateHistoryIngestPipelineId)(definition);
  const latestIngestPipelineId = (0, _generate_latest_ingest_pipeline_id.generateLatestIngestPipelineId)(definition);
  const [ingestPipelines, transforms] = await Promise.all([esClient.ingest.getPipeline({
    id: `${historyIngestPipelineId},${latestIngestPipelineId}`
  }), esClient.transform.getTransformStats({
    transform_id: [(0, _generate_history_transform_id.generateHistoryTransformId)(definition), (0, _generate_latest_transform_id.generateLatestTransformId)(definition)]
  })]);
  const ingestPipelinesInstalled = !!(ingestPipelines[historyIngestPipelineId] && ingestPipelines[latestIngestPipelineId]);
  const transformsInstalled = transforms.count === 2;
  const transformsRunning = transformsInstalled && transforms.transforms.every(transform => transform.state === 'started' || transform.state === 'indexing');
  return {
    installed: ingestPipelinesInstalled && transformsInstalled,
    running: transformsRunning
  };
}