"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteHistoryIngestPipeline = deleteHistoryIngestPipeline;
exports.deleteLatestIngestPipeline = deleteLatestIngestPipeline;
var _retry = require("./helpers/retry");
var _generate_latest_ingest_pipeline_id = require("./ingest_pipeline/generate_latest_ingest_pipeline_id");
var _generate_history_ingest_pipeline_id = require("./ingest_pipeline/generate_history_ingest_pipeline_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteHistoryIngestPipeline(esClient, definition, logger) {
  try {
    const historyPipelineId = (0, _generate_history_ingest_pipeline_id.generateHistoryIngestPipelineId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.deletePipeline({
      id: historyPipelineId
    }, {
      ignore: [404]
    }));
  } catch (e) {
    logger.error(`Unable to delete history ingest pipeline [${definition.id}].`);
    throw e;
  }
}
async function deleteLatestIngestPipeline(esClient, definition, logger) {
  try {
    const latestPipelineId = (0, _generate_latest_ingest_pipeline_id.generateLatestIngestPipelineId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.deletePipeline({
      id: latestPipelineId
    }, {
      ignore: [404]
    }));
  } catch (e) {
    logger.error(`Unable to delete latest ingest pipeline [${definition.id}].`);
    throw e;
  }
}