"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIndices = deleteIndices;
var _generate_index_name = require("./helpers/generate_index_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteIndices(esClient, definition, logger) {
  try {
    const response = await esClient.indices.resolveIndex({
      name: `${(0, _generate_index_name.generateHistoryIndexName)(definition)}.*,${(0, _generate_index_name.generateLatestIndexName)(definition)}`
    });
    const indices = response.indices.map(doc => doc.name);
    if (indices.length) {
      await esClient.indices.delete({
        index: indices,
        ignore_unavailable: true
      });
    }
  } catch (e) {
    logger.error(`Unable to remove entity definition index [${definition.id}}]`);
    throw e;
  }
}