"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteEntityDefinition = deleteEntityDefinition;
var _saved_objects = require("../../saved_objects");
var _entity_not_found = require("./errors/entity_not_found");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteEntityDefinition(soClient, definition, logger) {
  const response = await soClient.find({
    type: _saved_objects.SO_ENTITY_DEFINITION_TYPE,
    page: 1,
    perPage: 1,
    filter: `${_saved_objects.SO_ENTITY_DEFINITION_TYPE}.attributes.id:(${definition.id})`
  });
  if (response.total === 0) {
    logger.error(`Unable to delete entity definition [${definition.id}] because it doesn't exist.`);
    throw new _entity_not_found.EntityDefinitionNotFound(`Entity definition with [${definition.id}] not found.`);
  }
  await soClient.delete(_saved_objects.SO_ENTITY_DEFINITION_TYPE, response.saved_objects[0].id);
}