"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAndInstallHistoryTransform = createAndInstallHistoryTransform;
exports.createAndInstallLatestTransform = createAndInstallLatestTransform;
var _retry = require("./helpers/retry");
var _generate_latest_transform = require("./transform/generate_latest_transform");
var _generate_history_transform = require("./transform/generate_history_transform");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createAndInstallHistoryTransform(esClient, definition, logger) {
  try {
    const historyTransform = (0, _generate_history_transform.generateHistoryTransform)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.putTransform(historyTransform), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot create entity history transform for [${definition.id}] entity definition`);
    throw e;
  }
}
async function createAndInstallLatestTransform(esClient, definition, logger) {
  try {
    const latestTransform = (0, _generate_latest_transform.generateLatestTransform)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.putTransform(latestTransform), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot create entity latest transform for [${definition.id}] entity definition`);
    throw e;
  }
}