"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAndInstallHistoryIngestPipeline = createAndInstallHistoryIngestPipeline;
exports.createAndInstallLatestIngestPipeline = createAndInstallLatestIngestPipeline;
var _retry = require("./helpers/retry");
var _generate_latest_processors = require("./ingest_pipeline/generate_latest_processors");
var _generate_latest_ingest_pipeline_id = require("./ingest_pipeline/generate_latest_ingest_pipeline_id");
var _generate_history_processors = require("./ingest_pipeline/generate_history_processors");
var _generate_history_ingest_pipeline_id = require("./ingest_pipeline/generate_history_ingest_pipeline_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createAndInstallHistoryIngestPipeline(esClient, definition, logger, spaceId) {
  try {
    const historyProcessors = (0, _generate_history_processors.generateHistoryProcessors)(definition, spaceId);
    const historyId = (0, _generate_history_ingest_pipeline_id.generateHistoryIngestPipelineId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.putPipeline({
      id: historyId,
      processors: historyProcessors
    }), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot create entity history ingest pipelines for [${definition.id}] entity defintion`);
    throw e;
  }
}
async function createAndInstallLatestIngestPipeline(esClient, definition, logger, spaceId) {
  try {
    const latestProcessors = (0, _generate_latest_processors.generateLatestProcessors)(definition, spaceId);
    const latestId = (0, _generate_latest_ingest_pipeline_id.generateLatestIngestPipelineId)(definition);
    await (0, _retry.retryTransientEsErrors)(() => esClient.ingest.putPipeline({
      id: latestId,
      processors: latestProcessors
    }), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot create entity latest ingest pipelines for [${definition.id}] entity defintion`);
    throw e;
  }
}