"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtInServicesEntityDefinition = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builtInServicesEntityDefinition = exports.builtInServicesEntityDefinition = _entitiesSchema.entityDefinitionSchema.parse({
  id: `${_constants.BUILT_IN_ID_PREFIX}services`,
  name: 'Services from logs',
  type: 'service',
  managed: true,
  indexPatterns: ['logs-*', 'filebeat*'],
  history: {
    timestampField: '@timestamp',
    interval: '1m'
  },
  latest: {
    lookback: '5m'
  },
  identityFields: ['service.name', {
    field: 'service.environment',
    optional: true
  }],
  displayNameTemplate: '{{service.name}}{{#service.environment}}:{{.}}{{/service.environment}}',
  metadata: ['data_stream.type', 'service.instance.id', 'service.namespace', 'service.version', 'service.runtime.name', 'service.runtime.version', 'service.node.name', 'service.language.name', 'agent.name', 'cloud.provider', 'cloud.instance.id', 'cloud.availability_zone', 'cloud.instance.name', 'cloud.machine.type', 'host.name', 'container.id'],
  metrics: [{
    name: 'logRate',
    equation: 'A / 5',
    metrics: [{
      name: 'A',
      aggregation: 'doc_count',
      filter: 'log.level: *'
    }]
  }, {
    name: 'errorRate',
    equation: 'A / 5',
    metrics: [{
      name: 'A',
      aggregation: 'doc_count',
      filter: 'log.level: "ERROR"'
    }]
  }]
});