"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requiredRunTimePrivileges = exports.requiredEnablementPrivileges = exports.canRunEntityDiscovery = exports.canEnableEntityDiscovery = void 0;
var _constants_entities = require("../../../common/constants_entities");
var _constants = require("../entities/built_in/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requiredRunTimePrivileges = exports.requiredRunTimePrivileges = {
  // all of
  index: [{
    names: [`${_constants_entities.ENTITY_BASE_PREFIX}*`],
    privileges: ['create_index', 'index', 'create_doc', 'auto_configure', 'read']
  }, {
    names: [..._constants.BUILT_IN_ALLOWED_INDICES, `${_constants_entities.ENTITY_BASE_PREFIX}*`],
    privileges: ['read', 'view_index_metadata']
  }],
  cluster: ['manage_transform', 'monitor_transform', 'manage_ingest_pipelines', 'monitor'],
  application: [{
    application: 'kibana-.kibana',
    privileges: ['saved_object:entity-definition/*'],
    resources: ['*']
  }]
};
const requiredEnablementPrivileges = exports.requiredEnablementPrivileges = {
  // any one of
  cluster: ['manage_security', 'manage_api_key', 'manage_own_api_key']
};
const canRunEntityDiscovery = async client => {
  const {
    has_all_requested: hasAllRequested
  } = await client.security.hasPrivileges({
    body: {
      cluster: requiredRunTimePrivileges.cluster,
      index: requiredRunTimePrivileges.index,
      application: requiredRunTimePrivileges.application
    }
  });
  return hasAllRequested;
};
exports.canRunEntityDiscovery = canRunEntityDiscovery;
const canEnableEntityDiscovery = async client => {
  const [canRun, {
    cluster: grantedClusterPrivileges
  }] = await Promise.all([canRunEntityDiscovery(client), client.security.hasPrivileges({
    body: {
      cluster: requiredEnablementPrivileges.cluster
    }
  })]);
  return canRun && requiredEnablementPrivileges.cluster.some(k => grantedClusterPrivileges[k] === true);
};
exports.canEnableEntityDiscovery = canEnableEntityDiscovery;