"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityClient = void 0;
var _constants_entities = require("../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EntityClient {
  constructor(http) {
    this.http = http;
  }
  async isManagedEntityDiscoveryEnabled() {
    return await this.http.get(_constants_entities.MANAGED_ENTITY_ENABLEMENT_ROUTE);
  }
  async enableManagedEntityDiscovery() {
    return await this.http.put(_constants_entities.MANAGED_ENTITY_ENABLEMENT_ROUTE);
  }
  async disableManagedEntityDiscovery() {
    return await this.http.delete(_constants_entities.MANAGED_ENTITY_ENABLEMENT_ROUTE);
  }
}
exports.EntityClient = EntityClient;