"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGED_ENTITY_ENABLEMENT_ROUTE = exports.ENTITY_VERSION = exports.ENTITY_LATEST_TRANSFORM_PREFIX = exports.ENTITY_LATEST_BASE_PREFIX = exports.ENTITY_INTERNAL_API_PREFIX = exports.ENTITY_HISTORY_TRANSFORM_PREFIX = exports.ENTITY_HISTORY_BASE_PREFIX = exports.ENTITY_DEFAULT_METADATA_LIMIT = exports.ENTITY_DEFAULT_LATEST_SYNC_DELAY = exports.ENTITY_DEFAULT_LATEST_FREQUENCY = exports.ENTITY_DEFAULT_HISTORY_SYNC_DELAY = exports.ENTITY_DEFAULT_HISTORY_FREQUENCY = exports.ENTITY_BASE_PREFIX = exports.ENTITY_API_PREFIX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_VERSION = exports.ENTITY_VERSION = 'v1';
const ENTITY_BASE_PREFIX = exports.ENTITY_BASE_PREFIX = '.entities-observability';
const ENTITY_HISTORY_BASE_PREFIX = exports.ENTITY_HISTORY_BASE_PREFIX = `${ENTITY_BASE_PREFIX}.history-${ENTITY_VERSION}`;
const ENTITY_LATEST_BASE_PREFIX = exports.ENTITY_LATEST_BASE_PREFIX = `${ENTITY_BASE_PREFIX}.latest-${ENTITY_VERSION}`;
const ENTITY_HISTORY_TRANSFORM_PREFIX = exports.ENTITY_HISTORY_TRANSFORM_PREFIX = `entity-history-${ENTITY_VERSION}`;
const ENTITY_LATEST_TRANSFORM_PREFIX = exports.ENTITY_LATEST_TRANSFORM_PREFIX = `entity-latest-${ENTITY_VERSION}`;
const ENTITY_DEFAULT_HISTORY_FREQUENCY = exports.ENTITY_DEFAULT_HISTORY_FREQUENCY = '1m';
const ENTITY_DEFAULT_HISTORY_SYNC_DELAY = exports.ENTITY_DEFAULT_HISTORY_SYNC_DELAY = '60s';
const ENTITY_DEFAULT_LATEST_FREQUENCY = exports.ENTITY_DEFAULT_LATEST_FREQUENCY = '30s';
const ENTITY_DEFAULT_LATEST_SYNC_DELAY = exports.ENTITY_DEFAULT_LATEST_SYNC_DELAY = '1s';
const ENTITY_DEFAULT_METADATA_LIMIT = exports.ENTITY_DEFAULT_METADATA_LIMIT = 1000;
const ENTITY_API_PREFIX = exports.ENTITY_API_PREFIX = '/api/entities';
const ENTITY_INTERNAL_API_PREFIX = exports.ENTITY_INTERNAL_API_PREFIX = '/internal/api/entities';
const MANAGED_ENTITY_ENABLEMENT_ROUTE = exports.MANAGED_ENTITY_ENABLEMENT_ROUTE = `${ENTITY_INTERNAL_API_PREFIX}/managed/enablement`;