"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityDefinitionSchema = void 0;
var _zod = require("zod");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityDefinitionSchema = exports.entityDefinitionSchema = _zod.z.object({
  id: _zod.z.string().regex(/^[\w-]+$/),
  name: _zod.z.string(),
  description: _zod.z.optional(_zod.z.string()),
  type: _zod.z.string(),
  filter: _common.filterSchema,
  indexPatterns: _common.arrayOfStringsSchema,
  identityFields: _zod.z.array(_common.identityFieldsSchema),
  displayNameTemplate: _zod.z.string(),
  metadata: _zod.z.optional(_zod.z.array(_common.metadataSchema)),
  metrics: _zod.z.optional(_zod.z.array(_common.keyMetricSchema)),
  staticFields: _zod.z.optional(_zod.z.record(_zod.z.string(), _zod.z.string())),
  managed: _zod.z.optional(_zod.z.boolean()).default(false),
  history: _zod.z.object({
    timestampField: _zod.z.string(),
    interval: _common.durationSchema.refine(val => val.asMinutes() >= 1, {
      message: 'The history.interval can not be less than 1m'
    }),
    lookbackPeriod: _zod.z.optional(_common.durationSchema),
    settings: _zod.z.optional(_zod.z.object({
      syncField: _zod.z.optional(_zod.z.string()),
      syncDelay: _zod.z.optional(_zod.z.string()),
      frequency: _zod.z.optional(_zod.z.string())
    }))
  }),
  latest: _zod.z.optional(_zod.z.object({
    settings: _zod.z.optional(_zod.z.object({
      syncField: _zod.z.optional(_zod.z.string()),
      syncDelay: _zod.z.optional(_zod.z.string()),
      frequency: _zod.z.optional(_zod.z.string())
    }))
  }))
});