"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entitySummarySchema = exports.entityHistorySchema = void 0;
var _zod = require("zod");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entitySchema = _zod.z.object({
  entity: _zod.z.object({
    id: _zod.z.string(),
    identityFields: _common.arrayOfStringsSchema,
    displayName: _zod.z.string(),
    spaceId: _zod.z.string(),
    metrics: _zod.z.record(_zod.z.string(), _zod.z.number())
  })
});
const entitySummarySchema = exports.entitySummarySchema = _zod.z.intersection(entitySchema.extend({
  lastSeenTimestamp: _zod.z.string(),
  firstSeenTimestamp: _zod.z.string()
}), _zod.z.record(_zod.z.string(), _zod.z.string().or(_zod.z.number())));
const entityHistorySchema = exports.entityHistorySchema = _zod.z.intersection(entitySchema.extend({
  ['@timestamp']: _zod.z.string()
}), _zod.z.record(_zod.z.string(), _zod.z.string().or(_zod.z.number())));