"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.percentileMetricSchema = exports.metricSchema = exports.metadataSchema = exports.keyMetricSchema = exports.identityFieldsSchema = exports.filterSchema = exports.durationSchema = exports.docCountMetricSchema = exports.basicMetricWithFieldSchema = exports.basicAggregationsSchema = exports.arrayOfStringsSchema = exports.BasicAggregations = void 0;
var _zod = require("zod");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayOfStringsSchema = exports.arrayOfStringsSchema = _zod.z.array(_zod.z.string());
let BasicAggregations = exports.BasicAggregations = /*#__PURE__*/function (BasicAggregations) {
  BasicAggregations["avg"] = "avg";
  BasicAggregations["max"] = "max";
  BasicAggregations["min"] = "min";
  BasicAggregations["sum"] = "sum";
  BasicAggregations["cardinality"] = "cardinality";
  BasicAggregations["last_value"] = "last_value";
  BasicAggregations["std_deviation"] = "std_deviation";
  return BasicAggregations;
}({});
const basicAggregationsSchema = exports.basicAggregationsSchema = _zod.z.nativeEnum(BasicAggregations);
const metricNameSchema = _zod.z.string().length(1).regex(/[a-zA-Z]/).toUpperCase();
const filterSchema = exports.filterSchema = _zod.z.optional(_zod.z.string());
const basicMetricWithFieldSchema = exports.basicMetricWithFieldSchema = _zod.z.object({
  name: metricNameSchema,
  aggregation: basicAggregationsSchema,
  field: _zod.z.string(),
  filter: filterSchema
});
const docCountMetricSchema = exports.docCountMetricSchema = _zod.z.object({
  name: metricNameSchema,
  aggregation: _zod.z.literal('doc_count'),
  filter: filterSchema
});
const durationSchema = exports.durationSchema = _zod.z.string().regex(/\d+[m|d|s|h]/).transform(val => {
  const parts = val.match(/(\d+)([m|s|h|d])/);
  if (parts === null) {
    throw new Error('Unable to parse duration');
  }
  const value = parseInt(parts[1], 10);
  const unit = parts[2];
  const duration = _moment.default.duration(value, unit);
  duration.toJSON = () => val;
  return duration;
});
const percentileMetricSchema = exports.percentileMetricSchema = _zod.z.object({
  name: metricNameSchema,
  aggregation: _zod.z.literal('percentile'),
  field: _zod.z.string(),
  percentile: _zod.z.number(),
  filter: filterSchema
});
const metricSchema = exports.metricSchema = _zod.z.discriminatedUnion('aggregation', [basicMetricWithFieldSchema, docCountMetricSchema, percentileMetricSchema]);
const keyMetricSchema = exports.keyMetricSchema = _zod.z.object({
  name: _zod.z.string(),
  metrics: _zod.z.array(metricSchema),
  equation: _zod.z.string()
});
const metadataSchema = exports.metadataSchema = _zod.z.object({
  source: _zod.z.string(),
  destination: _zod.z.optional(_zod.z.string()),
  limit: _zod.z.optional(_zod.z.number().default(1000))
}).or(_zod.z.string().transform(value => ({
  source: value,
  destination: value,
  limit: 1000
})));
const identityFieldsSchema = exports.identityFieldsSchema = _zod.z.object({
  field: _zod.z.string(),
  optional: _zod.z.boolean()
}).or(_zod.z.string().transform(value => ({
  field: value,
  optional: false
})));