"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPipelineParameters = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _get_default_pipeline = require("./get_default_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexPipelineParameters = async (indexName, client) => {
  // Get the default pipeline data and check for a custom pipeline in parallel
  // we want to throw the error if getDefaultPipeline() fails so we're not catching it on purpose
  const [defaultPipeline, connector, customPipelineResp] = await Promise.all([(0, _get_default_pipeline.getDefaultPipeline)(client), (0, _searchConnectors.fetchConnectorByIndexName)(client.asCurrentUser, indexName), client.asCurrentUser.ingest.getPipeline({
    id: `${indexName}`
  }).catch(() => null)]);
  if (connector && connector.pipeline) {
    return connector.pipeline;
  }
  const pipelineName = customPipelineResp !== null && customPipelineResp !== void 0 && customPipelineResp[indexName] ? indexName : defaultPipeline.name;
  return {
    ...defaultPipeline,
    name: pipelineName
  };
};
exports.getIndexPipelineParameters = getIndexPipelineParameters;