"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/search-api-panels/constants");
var _constants2 = require("../common/constants");
var _create_index_locator = require("../common/locators/create_index_locator");
var _routes = require("./applications/app_search/routes");
var _routes2 = require("./applications/applications/routes");
var _routes3 = require("./applications/enterprise_search_content/routes");
var _routes4 = require("./applications/enterprise_search_relevance/routes");
var _doc_links = require("./applications/shared/doc_links");
var _breadcrumbs_home = require("./applications/shared/kibana_chrome/breadcrumbs_home");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const contentLinks = [{
  id: 'connectors',
  path: `/${_routes3.CONNECTORS_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.contentConnectorsLinkLabel', {
    defaultMessage: 'Connectors'
  })
}, {
  id: 'searchIndices',
  path: `/${_routes3.SEARCH_INDICES_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.contentIndicesLinkLabel', {
    defaultMessage: 'Indices'
  })
}, {
  id: 'webCrawlers',
  path: `/${_routes3.CRAWLERS_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.contentWebcrawlersLinkLabel', {
    defaultMessage: 'Web crawlers'
  })
}];
const relevanceLinks = [{
  id: 'inferenceEndpoints',
  path: `/${_routes4.INFERENCE_ENDPOINTS_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.relevanceInferenceEndpointsLinkLabel', {
    defaultMessage: 'Inference Endpoints'
  }),
  visibleIn: ['globalSearch']
}];
const applicationsLinks = [{
  id: 'playground',
  path: `/${_routes2.PLAYGROUND_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.contentPlaygroundLinkLabel', {
    defaultMessage: 'Playground'
  }),
  visibleIn: ['sideNav', 'globalSearch']
}, {
  id: 'searchApplications',
  path: `/${_routes2.SEARCH_APPLICATIONS_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.applicationsSearchApplicationsLinkLabel', {
    defaultMessage: 'Search Applications'
  }),
  visibleIn: ['globalSearch']
}];
const appSearchLinks = [{
  id: 'engines',
  path: `/${_routes.ENGINES_PATH}`,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.navigation.appSearchEnginesLinkLabel', {
    defaultMessage: 'Engines'
  })
}];
class EnterpriseSearchPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "licenseSubscription", null);
    (0, _defineProperty2.default)(this, "data", {});
    (0, _defineProperty2.default)(this, "esConfig", void 0);
    (0, _defineProperty2.default)(this, "hasInitialized", false);
    (0, _defineProperty2.default)(this, "isSidebarEnabled", true);
    (0, _defineProperty2.default)(this, "sideNavDynamicItems$", new _rxjs.BehaviorSubject({}));
    (0, _defineProperty2.default)(this, "updateSideNavDefinition", items => {
      this.sideNavDynamicItems$.next({
        ...this.sideNavDynamicItems$.getValue(),
        ...items
      });
    });
    this.config = initializerContext.config.get();
    this.esConfig = {
      elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
    };
  }
  async getInitialData(http) {
    try {
      this.esConfig = await http.get('/internal/enterprise_search/es_config');
    } catch {
      this.esConfig = {
        elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
      };
    }
    if (!this.config.host) return; // No API to call
    if (this.hasInitialized) return; // We've already made an initial call

    try {
      this.data = await http.get('/internal/enterprise_search/config_data');
      this.hasInitialized = true;
    } catch (e) {
      this.data.errorConnectingMessage = `${e.response.status} ${e.message}`;
    }
  }
  async getKibanaDeps(core, params, cloudSetup) {
    // Helper for using start dependencies on mount (instead of setup dependencies)
    // and for grouping Kibana-related args together (vs. plugin-specific args)
    const [coreStart, pluginsStart] = await core.getStartServices();
    const cloud = cloudSetup && pluginsStart.cloud ? {
      ...cloudSetup,
      ...pluginsStart.cloud
    } : undefined;
    const plugins = {
      ...pluginsStart,
      cloud
    };
    const chromeStyle = await (0, _rxjs.firstValueFrom)(coreStart.chrome.getChromeStyle$());
    this.isSidebarEnabled = chromeStyle === 'classic';
    coreStart.chrome.getChromeStyle$().subscribe(style => {
      this.isSidebarEnabled = style === 'classic';
    });
    return {
      core: coreStart,
      isSidebarEnabled: this.isSidebarEnabled,
      params,
      plugins,
      updateSideNavDefinition: this.updateSideNavDefinition.bind(this)
    };
  }
  getPluginData() {
    // Small helper for grouping plugin data related args together
    return {
      config: this.config,
      data: this.data,
      esConfig: this.esConfig,
      isSidebarEnabled: this.isSidebarEnabled
    };
  }
  setup(core, plugins) {
    var _config$ui;
    const {
      config
    } = this;
    if (!((_config$ui = config.ui) !== null && _config$ui !== void 0 && _config$ui.enabled)) {
      return;
    }
    const {
      cloud,
      share,
      licensing
    } = plugins;
    const useSearchHomepage = plugins.searchHomepage && plugins.searchHomepage.isHomepageFeatureEnabled();
    if (useSearchHomepage) {
      const {
        app
      } = plugins.searchHomepage;
      core.application.register({
        ...app,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        visibleIn: ['home', 'kibanaOverview', 'globalSearch', 'sideNav'],
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(app.title);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            SearchHomepage
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/search_homepage')));
          return renderApp(SearchHomepage, kibanaDeps, pluginData);
        }
      });
      (0, _breadcrumbs_home.setBreadcrumbHomeUrl)(app.appRoute);
    } else {
      core.application.register({
        appRoute: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        id: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAME);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            EnterpriseSearchOverview
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_overview')));
          return renderApp(EnterpriseSearchOverview, kibanaDeps, pluginData);
        },
        title: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAV_TITLE,
        visibleIn: ['home', 'kibanaOverview', 'globalSearch', 'sideNav']
      });
    }
    core.application.register({
      appRoute: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      deepLinks: contentLinks,
      euiIconType: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.LOGO,
      id: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchContent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_content')));
        return renderApp(EnterpriseSearchContent, kibanaDeps, pluginData);
      },
      title: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.ELASTICSEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.ELASTICSEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ELASTICSEARCH_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Elasticsearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/elasticsearch')));
        return renderApp(Elasticsearch, kibanaDeps, pluginData);
      },
      title: _constants2.ELASTICSEARCH_PLUGIN.NAME
    });
    core.application.register({
      appRoute: _constants2.VECTOR_SEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.VECTOR_SEARCH_PLUGIN.LOGO,
      id: _constants2.VECTOR_SEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.VECTOR_SEARCH_PLUGIN.NAME);
        this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchVectorSearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/vector_search')));
        return renderApp(EnterpriseSearchVectorSearch, kibanaDeps, pluginData);
      },
      title: _constants2.VECTOR_SEARCH_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.SEMANTIC_SEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.SEMANTIC_SEARCH_PLUGIN.LOGO,
      id: _constants2.SEMANTIC_SEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.SEMANTIC_SEARCH_PLUGIN.NAME);
        this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchSemanticSearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/semantic_search')));
        return renderApp(EnterpriseSearchSemanticSearch, kibanaDeps, pluginData);
      },
      title: _constants2.SEMANTIC_SEARCH_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.AI_SEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.AI_SEARCH_PLUGIN.LOGO,
      id: _constants2.AI_SEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.AI_SEARCH_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchAISearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/ai_search')));
        return renderApp(EnterpriseSearchAISearch, kibanaDeps, pluginData);
      },
      title: _constants2.AI_SEARCH_PLUGIN.NAV_TITLE,
      visibleIn: []
    });
    core.application.register({
      appRoute: _constants2.APPLICATIONS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      deepLinks: applicationsLinks,
      euiIconType: _constants2.APPLICATIONS_PLUGIN.LOGO,
      id: _constants2.APPLICATIONS_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Applications
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/applications')));
        return renderApp(Applications, kibanaDeps, pluginData);
      },
      title: _constants2.APPLICATIONS_PLUGIN.NAV_TITLE,
      visibleIn: []
    });
    core.application.register({
      appRoute: _constants2.ANALYTICS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.ANALYTICS_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ANALYTICS_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Analytics
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/analytics')));
        return renderApp(Analytics, kibanaDeps, pluginData);
      },
      title: _constants2.ANALYTICS_PLUGIN.NAME
    });
    this.licenseSubscription = licensing === null || licensing === void 0 ? void 0 : licensing.license$.subscribe(license => {
      if (license.isActive && license.hasAtLeast('enterprise')) {
        core.application.register({
          appRoute: _constants2.INFERENCE_ENDPOINTS_PLUGIN.URL,
          category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
          deepLinks: relevanceLinks,
          euiIconType: _constants2.INFERENCE_ENDPOINTS_PLUGIN.LOGO,
          id: _constants2.INFERENCE_ENDPOINTS_PLUGIN.ID,
          mount: async params => {
            const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
            const {
              chrome,
              http
            } = kibanaDeps.core;
            chrome.docTitle.change(_constants2.INFERENCE_ENDPOINTS_PLUGIN.NAME);
            await this.getInitialData(http);
            const pluginData = this.getPluginData();
            const {
              renderApp
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
            const {
              EnterpriseSearchRelevance
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_relevance')));
            return renderApp(EnterpriseSearchRelevance, kibanaDeps, pluginData);
          },
          title: _constants2.INFERENCE_ENDPOINTS_PLUGIN.NAV_TITLE,
          visibleIn: []
        });
      }
    });
    core.application.register({
      appRoute: _constants2.SEARCH_EXPERIENCES_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.SEARCH_EXPERIENCES_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.SEARCH_EXPERIENCES_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          SearchExperiences
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/search_experiences')));
        return renderApp(SearchExperiences, kibanaDeps, pluginData);
      },
      title: _constants2.SEARCH_EXPERIENCES_PLUGIN.NAME,
      visibleIn: []
    });
    share === null || share === void 0 ? void 0 : share.url.locators.create(new _create_index_locator.CreatIndexLocatorDefinition());
    if (config.canDeployEntSearch) {
      core.application.register({
        appRoute: _constants2.APP_SEARCH_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        deepLinks: appSearchLinks,
        euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        id: _constants2.APP_SEARCH_PLUGIN.ID,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants2.APP_SEARCH_PLUGIN.NAME);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            AppSearch
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/app_search')));
          return renderApp(AppSearch, kibanaDeps, pluginData);
        },
        title: _constants2.APP_SEARCH_PLUGIN.NAME,
        visibleIn: []
      });
      core.application.register({
        appRoute: _constants2.WORKPLACE_SEARCH_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        id: _constants2.WORKPLACE_SEARCH_PLUGIN.ID,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants2.WORKPLACE_SEARCH_PLUGIN.NAME);

          // The Workplace Search Personal dashboard needs the chrome hidden. We hide it globally
          // here first to prevent a flash of chrome on the Personal dashboard and unhide it for admin routes.
          if (this.config.host) chrome.setIsVisible(false);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            WorkplaceSearch
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/workplace_search')));
          return renderApp(WorkplaceSearch, kibanaDeps, pluginData);
        },
        title: _constants2.WORKPLACE_SEARCH_PLUGIN.NAME,
        visibleIn: []
      });
    }
    if (plugins.home) {
      if (useSearchHomepage) {
        const {
          searchHomepage
        } = plugins;
        plugins.home.featureCatalogue.registerSolution({
          description: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.DESCRIPTION,
          icon: 'logoEnterpriseSearch',
          id: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
          order: 100,
          path: searchHomepage.app.appRoute,
          title: _constants2.SEARCH_PRODUCT_NAME
        });
      } else {
        plugins.home.featureCatalogue.registerSolution({
          description: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.DESCRIPTION,
          icon: 'logoEnterpriseSearch',
          id: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
          order: 100,
          path: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL,
          title: _constants2.SEARCH_PRODUCT_NAME
        });
      }
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.ANALYTICS_PLUGIN.DESCRIPTION,
        icon: 'appAnalytics',
        id: _constants2.ANALYTICS_PLUGIN.ID,
        path: _constants2.ANALYTICS_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.ANALYTICS_PLUGIN.NAME
      });
      if (config.canDeployEntSearch) {
        plugins.home.featureCatalogue.register({
          category: 'data',
          description: _constants2.APP_SEARCH_PLUGIN.DESCRIPTION,
          icon: 'appSearchApp',
          id: _constants2.APP_SEARCH_PLUGIN.ID,
          path: _constants2.APP_SEARCH_PLUGIN.URL,
          showOnHomePage: false,
          title: _constants2.APP_SEARCH_PLUGIN.NAME
        });
        plugins.home.featureCatalogue.register({
          category: 'data',
          description: _constants2.WORKPLACE_SEARCH_PLUGIN.DESCRIPTION,
          icon: 'workplaceSearchApp',
          id: _constants2.WORKPLACE_SEARCH_PLUGIN.ID,
          path: _constants2.WORKPLACE_SEARCH_PLUGIN.URL,
          showOnHomePage: false,
          title: _constants2.WORKPLACE_SEARCH_PLUGIN.NAME
        });
      }
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.ELASTICSEARCH_PLUGIN.DESCRIPTION,
        icon: 'appElasticsearch',
        id: _constants2.ELASTICSEARCH_PLUGIN.ID,
        path: _constants2.ELASTICSEARCH_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.ELASTICSEARCH_PLUGIN.NAME
      });
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.SEARCH_EXPERIENCES_PLUGIN.DESCRIPTION,
        icon: 'logoEnterpriseSearch',
        id: _constants2.SEARCH_EXPERIENCES_PLUGIN.ID,
        path: _constants2.SEARCH_EXPERIENCES_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.SEARCH_EXPERIENCES_PLUGIN.NAME
      });
    }
  }
  start(core, plugins) {
    var _this$config$ui;
    if (!((_this$config$ui = this.config.ui) !== null && _this$config$ui !== void 0 && _this$config$ui.enabled)) {
      return;
    }
    // This must be called here in start() and not in `applications/index.tsx` to prevent loading
    // race conditions with our apps' `routes.ts` being initialized before `renderApp()`
    _doc_links.docLinks.setDocLinks(core.docLinks);
    Promise.resolve().then(() => _interopRequireWildcard(require('./navigation_tree'))).then(({
      getNavigationTreeDefinition
    }) => {
      var _plugins$searchHomepa, _plugins$searchHomepa2;
      return plugins.navigation.addSolutionNavigation(getNavigationTreeDefinition({
        dynamicItems$: this.sideNavDynamicItems$,
        isSearchHomepageEnabled: (_plugins$searchHomepa = (_plugins$searchHomepa2 = plugins.searchHomepage) === null || _plugins$searchHomepa2 === void 0 ? void 0 : _plugins$searchHomepa2.isHomepageFeatureEnabled()) !== null && _plugins$searchHomepa !== void 0 ? _plugins$searchHomepa : false
      }));
    });

    // Return empty start contract rather than void in order for plugins
    // that depend on the enterprise search plugin to determine whether it is enabled or not
    return {};
  }
  stop() {
    var _this$licenseSubscrip;
    (_this$licenseSubscrip = this.licenseSubscription) === null || _this$licenseSubscrip === void 0 ? void 0 : _this$licenseSubscrip.unsubscribe();
  }
}
exports.EnterpriseSearchPlugin = EnterpriseSearchPlugin;