"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _layout = require("../../../components/layout");
var _constants = require("../../../constants");
var _add_source_header = require("../../content_sources/components/add_source/add_source_header");
var _add_source_logic = require("../../content_sources/components/add_source/add_source_logic");
var _save_config = require("../../content_sources/components/add_source/save_config");
var _source_data = require("../../content_sources/source_data");
var _settings_logic = require("../settings_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceConfig = () => {
  const {
    serviceType
  } = (0, _reactRouterDom.useParams)();
  const [confirmModalVisible, setConfirmModalVisibility] = (0, _react.useState)(false);
  const addSourceLogic = (0, _add_source_logic.AddSourceLogic)({
    serviceType
  });
  const {
    deleteSourceConfig
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    saveSourceConfig,
    getSourceConfigData,
    resetSourceState
  } = (0, _kea.useActions)(addSourceLogic);
  const {
    sourceConfigData: {
      name,
      categories
    },
    dataLoading
  } = (0, _kea.useValues)(addSourceLogic);
  const sourceData = (0, _source_data.getSourceData)(serviceType);
  (0, _react.useEffect)(() => {
    getSourceConfigData();
    return resetSourceState;
  }, [serviceType]);
  if (!sourceData) {
    return null;
  }
  const {
    configuration
  } = sourceData;
  const hideConfirmModal = () => setConfirmModalVisibility(false);
  const showConfirmModal = () => setConfirmModalVisibility(true);
  const saveUpdatedConfig = () => saveSourceConfig(true);
  const header = /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: serviceType,
    categories: categories
  });
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.SETTINGS, _constants.NAV.SETTINGS_SOURCE_PRIORITIZATION, name || '...'],
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_save_config.SaveConfig, {
    name: name,
    configuration: configuration,
    advanceStep: saveUpdatedConfig,
    onDeleteConfig: showConfirmModal,
    header: header
  }), confirmModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onConfirm: () => deleteSourceConfig(serviceType, name),
    onCancel: hideConfirmModal,
    buttonColor: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.confirmRemoveConfigTitle', {
      defaultMessage: 'Remove configuration'
    }),
    confirmButtonText: _constants.REMOVE_BUTTON,
    cancelButtonText: _constants.CANCEL_BUTTON
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.confirmRemoveConfig.message', {
    defaultMessage: 'Are you sure you want to remove the configuration for {name}?',
    values: {
      name
    }
  })), serviceType === 'external' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "primary",
    iconType: "email",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/kibana/feedback",
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.feedbackCallOutText', {
      defaultMessage: 'Have feedback about deploying a {name} Connector Package? Let us know.',
      values: {
        name
      }
    }))
  })))));
};
exports.SourceConfig = SourceConfig;