"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticSourceData = exports.staticGenericExternalSourceData = exports.staticCustomSourceData = exports.hasMultipleConnectorOptions = exports.hasExternalConnectorOption = exports.hasCustomConnectorOption = exports.getSourceData = void 0;
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../shared/doc_links");
var _constants = require("../../constants");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticGenericExternalSourceData = exports.staticGenericExternalSourceData = {
  name: _constants.SOURCE_NAMES.CUSTOM_CONNECTOR_PACKAGE,
  categories: ['API', 'Custom'],
  serviceType: 'external',
  configuration: {
    hasOauthRedirect: false,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchCustomConnectorPackage,
    applicationPortalUrl: ''
  },
  objTypes: [],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [],
    platinumPrivateContext: []
  },
  accountContextOnly: false,
  isBeta: true
};
const staticSourceData = exports.staticSourceData = [{
  name: _constants.SOURCE_NAMES.BOX,
  serviceType: 'box',
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.CLOUD],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchBox,
    applicationPortalUrl: 'https://app.box.com/developers/console'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.FOLDERS, _constants.SOURCE_OBJ_TYPES.ALL_FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.CONFLUENCE,
  serviceType: 'confluence_cloud',
  categories: [_constants.SOURCE_CATEGORIES.WIKI, _constants.SOURCE_CATEGORIES.ATLASSIAN, _constants.SOURCE_CATEGORIES.INTRANET],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchConfluenceCloud,
    applicationPortalUrl: 'https://developer.atlassian.com/console/myapps/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.PAGES, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS, _constants.SOURCE_OBJ_TYPES.BLOG_POSTS, _constants.SOURCE_OBJ_TYPES.SPACES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.CONFLUENCE_CONNECTOR_PACKAGE,
  serviceType: 'external',
  baseServiceType: 'confluence_cloud',
  categories: [_constants.SOURCE_CATEGORIES.WIKI, _constants.SOURCE_CATEGORIES.ATLASSIAN, _constants.SOURCE_CATEGORIES.INTRANET],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchConfluenceCloudConnectorPackage,
    applicationPortalUrl: 'https://developer.atlassian.com/console/myapps/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.PAGES, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS, _constants.SOURCE_OBJ_TYPES.BLOG_POSTS, _constants.SOURCE_OBJ_TYPES.SPACES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false,
  isBeta: true
}, {
  name: _constants.SOURCE_NAMES.CONFLUENCE_SERVER,
  serviceType: 'confluence_server',
  categories: [_constants.SOURCE_CATEGORIES.WIKI, _constants.SOURCE_CATEGORIES.ATLASSIAN, _constants.SOURCE_CATEGORIES.INTRANET],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchConfluenceServer
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.PAGES, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS, _constants.SOURCE_OBJ_TYPES.BLOG_POSTS, _constants.SOURCE_OBJ_TYPES.SPACES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.DROPBOX,
  serviceType: 'dropbox',
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.CLOUD],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchDropbox,
    applicationPortalUrl: 'https://www.dropbox.com/developers/apps'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.FOLDERS, _constants.SOURCE_OBJ_TYPES.ALL_FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.GITHUB,
  serviceType: 'github',
  categories: [_constants.SOURCE_CATEGORIES.SOFTWARE, _constants.SOURCE_CATEGORIES.VERSION_CONTROL, _constants.SOURCE_CATEGORIES.CODE_REPOSITORY],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    needsConfiguration: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchGitHub,
    applicationPortalUrl: 'https://github.com/settings/developers',
    applicationLinkTitle: _constants.GITHUB_LINK_TITLE
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.ISSUES, _constants.SOURCE_OBJ_TYPES.PULL_REQUESTS, _constants.SOURCE_OBJ_TYPES.REPOSITORY_LIST, _constants.SOURCE_OBJ_TYPES.FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.GITHUB_ENTERPRISE,
  serviceType: 'github_enterprise_server',
  categories: [_constants.SOURCE_CATEGORIES.SOFTWARE, _constants.SOURCE_CATEGORIES.VERSION_CONTROL, _constants.SOURCE_CATEGORIES.CODE_REPOSITORY],
  configuration: {
    hasOauthRedirect: true,
    needsConfiguration: true,
    needsBaseUrl: true,
    baseUrlTitle: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.baseUrlTitles.github', {
      defaultMessage: 'GitHub Enterprise URL'
    }),
    documentationUrl: _doc_links.docLinks.workplaceSearchGitHub,
    applicationPortalUrl: 'https://github.com/settings/developers',
    applicationLinkTitle: _constants.GITHUB_LINK_TITLE
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.ISSUES, _constants.SOURCE_OBJ_TYPES.PULL_REQUESTS, _constants.SOURCE_OBJ_TYPES.REPOSITORY_LIST, _constants.SOURCE_OBJ_TYPES.FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.GMAIL,
  serviceType: 'gmail',
  categories: [_constants.SOURCE_CATEGORIES.COMMUNICATION, _constants.SOURCE_CATEGORIES.EMAIL, _constants.SOURCE_CATEGORIES.GOOGLE],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchGmail,
    applicationPortalUrl: 'https://console.developers.google.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.EMAILS],
  features: {
    platinumPrivateContext: [_types.FeatureIds.Remote, _types.FeatureIds.Private, _types.FeatureIds.SearchableContent]
  },
  accountContextOnly: true
}, {
  name: _constants.SOURCE_NAMES.GOOGLE_DRIVE,
  serviceType: 'google_drive',
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.CLOUD, _constants.SOURCE_CATEGORIES.PRODUCTIVITY, _constants.SOURCE_CATEGORIES.GSUITE],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchGoogleDrive,
    applicationPortalUrl: 'https://console.developers.google.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.FOLDERS, _constants.SOURCE_OBJ_TYPES.G_SUITE_FILES, _constants.SOURCE_OBJ_TYPES.ALL_STORED_FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.JIRA,
  serviceType: 'jira_cloud',
  categories: [_constants.SOURCE_CATEGORIES.SOFTWARE, _constants.SOURCE_CATEGORIES.BUG_TRACKING, _constants.SOURCE_CATEGORIES.ATLASSIAN, _constants.SOURCE_CATEGORIES.PROJECT_MANAGEMENT],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchJiraCloud,
    applicationPortalUrl: 'https://developer.atlassian.com/console/myapps/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.EPICS, _constants.SOURCE_OBJ_TYPES.PROJECTS, _constants.SOURCE_OBJ_TYPES.TASKS, _constants.SOURCE_OBJ_TYPES.STORIES, _constants.SOURCE_OBJ_TYPES.BUGS, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.JIRA_SERVER,
  serviceType: 'jira_server',
  categories: [_constants.SOURCE_CATEGORIES.SOFTWARE, _constants.SOURCE_CATEGORIES.BUG_TRACKING, _constants.SOURCE_CATEGORIES.ATLASSIAN, _constants.SOURCE_CATEGORIES.PROJECT_MANAGEMENT],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchJiraServer,
    applicationPortalUrl: ''
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.EPICS, _constants.SOURCE_OBJ_TYPES.PROJECTS, _constants.SOURCE_OBJ_TYPES.TASKS, _constants.SOURCE_OBJ_TYPES.STORIES, _constants.SOURCE_OBJ_TYPES.BUGS, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.NETWORK_DRVE,
  categories: [_constants.SOURCE_CATEGORIES.STORAGE],
  serviceType: 'custom',
  baseServiceType: 'network_drive',
  configuration: {
    hasOauthRedirect: false,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchNetworkDrive,
    applicationPortalUrl: '',
    githubRepository: 'elastic/enterprise-search-network-drive-connector'
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.ONEDRIVE,
  serviceType: 'one_drive',
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.CLOUD, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.MICROSOFT, _constants.SOURCE_CATEGORIES.OFFICE_365],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchOneDrive,
    applicationPortalUrl: 'https://portal.azure.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.FOLDERS, _constants.SOURCE_OBJ_TYPES.ALL_FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.SALESFORCE,
  serviceType: 'salesforce',
  categories: [_constants.SOURCE_CATEGORIES.CRM, _constants.SOURCE_CATEGORIES.CUSTOMER_RELATIONSHIP_MANAGEMENT, _constants.SOURCE_CATEGORIES.ACCOUNT_MANAGEMENT],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchSalesforce,
    applicationPortalUrl: 'https://salesforce.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.CONTACTS, _constants.SOURCE_OBJ_TYPES.OPPORTUNITIES, _constants.SOURCE_OBJ_TYPES.LEADS, _constants.SOURCE_OBJ_TYPES.ACCOUNTS, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS, _constants.SOURCE_OBJ_TYPES.CAMPAIGNS, _constants.SOURCE_OBJ_TYPES.CASES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.SALESFORCE_SANDBOX,
  serviceType: 'salesforce_sandbox',
  categories: [_constants.SOURCE_CATEGORIES.CRM, _constants.SOURCE_CATEGORIES.CUSTOMER_RELATIONSHIP_MANAGEMENT, _constants.SOURCE_CATEGORIES.ACCOUNT_MANAGEMENT],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchSalesforce,
    applicationPortalUrl: 'https://test.salesforce.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.CONTACTS, _constants.SOURCE_OBJ_TYPES.OPPORTUNITIES, _constants.SOURCE_OBJ_TYPES.LEADS, _constants.SOURCE_OBJ_TYPES.ACCOUNTS, _constants.SOURCE_OBJ_TYPES.ATTACHMENTS, _constants.SOURCE_OBJ_TYPES.CAMPAIGNS, _constants.SOURCE_OBJ_TYPES.CASES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.SERVICENOW,
  serviceType: 'service_now',
  categories: [_constants.SOURCE_CATEGORIES.WORKFLOW],
  configuration: {
    hasOauthRedirect: false,
    needsBaseUrl: true,
    needsCredentials: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchServiceNow,
    applicationPortalUrl: 'https://www.servicenow.com/my-account/sign-in.html'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.USERS, _constants.SOURCE_OBJ_TYPES.INCIDENTS, _constants.SOURCE_OBJ_TYPES.ITEMS, _constants.SOURCE_OBJ_TYPES.ARTICLES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.SHAREPOINT,
  serviceType: 'share_point',
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.CLOUD, _constants.SOURCE_CATEGORIES.MICROSOFT, _constants.SOURCE_CATEGORIES.OFFICE_365],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchSharePoint,
    applicationPortalUrl: 'https://portal.azure.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.FOLDERS, _constants.SOURCE_OBJ_TYPES.SITES, _constants.SOURCE_OBJ_TYPES.ALL_FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.SHAREPOINT_CONNECTOR_PACKAGE,
  serviceType: 'external',
  baseServiceType: 'share_point',
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.CLOUD, _constants.SOURCE_CATEGORIES.MICROSOFT, _constants.SOURCE_CATEGORIES.OFFICE_365],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchExternalSharePointOnline,
    applicationPortalUrl: 'https://portal.azure.com/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.ALL_STORED_FILES],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    basicOrgContextExcludedFeatures: [_types.FeatureIds.DocumentLevelPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false,
  isBeta: true
}, {
  name: _constants.SOURCE_NAMES.SHAREPOINT_SERVER,
  categories: [_constants.SOURCE_CATEGORIES.FILE_SHARING, _constants.SOURCE_CATEGORIES.STORAGE, _constants.SOURCE_CATEGORIES.CLOUD, _constants.SOURCE_CATEGORIES.MICROSOFT, _constants.SOURCE_CATEGORIES.OFFICE_365],
  serviceType: 'custom',
  baseServiceType: 'share_point_server',
  configuration: {
    hasOauthRedirect: false,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchSharePointServer,
    applicationPortalUrl: '',
    githubRepository: 'elastic/enterprise-search-sharepoint-server-connector'
  },
  accountContextOnly: false
}, {
  name: _constants.SOURCE_NAMES.SLACK,
  serviceType: 'slack',
  categories: [_constants.SOURCE_CATEGORIES.COLLABORATION, _constants.SOURCE_CATEGORIES.COMMUNICATION, _constants.SOURCE_CATEGORIES.INSTANT_MESSAGING, _constants.SOURCE_CATEGORIES.CHAT],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchSlack,
    applicationPortalUrl: 'https://api.slack.com/apps/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.PUBLIC_MESSAGES, _constants.SOURCE_OBJ_TYPES.PRIVATE_MESSAGES, _constants.SOURCE_OBJ_TYPES.DIRECT_MESSAGES],
  features: {
    platinumPrivateContext: [_types.FeatureIds.Remote, _types.FeatureIds.Private, _types.FeatureIds.SearchableContent]
  },
  accountContextOnly: true
}, {
  name: _constants.SOURCE_NAMES.ZENDESK,
  serviceType: 'zendesk',
  categories: [_constants.SOURCE_CATEGORIES.HELP, _constants.SOURCE_CATEGORIES.CUSTOMER_SERVICE, _constants.SOURCE_CATEGORIES.CUSTOMER_RELATIONSHIP_MANAGEMENT, _constants.SOURCE_CATEGORIES.TICKETING, _constants.SOURCE_CATEGORIES.HELPDESK],
  configuration: {
    hasOauthRedirect: true,
    needsBaseUrl: false,
    needsSubdomain: true,
    documentationUrl: _doc_links.docLinks.workplaceSearchZendesk,
    applicationPortalUrl: 'https://www.zendesk.com/login/'
  },
  objTypes: [_constants.SOURCE_OBJ_TYPES.TICKETS],
  features: {
    basicOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems, _types.FeatureIds.GlobalAccessPermissions],
    platinumOrgContext: [_types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems],
    platinumPrivateContext: [_types.FeatureIds.Private, _types.FeatureIds.SyncFrequency, _types.FeatureIds.SyncedItems]
  },
  accountContextOnly: false
}, staticGenericExternalSourceData];
const staticCustomSourceData = exports.staticCustomSourceData = {
  name: _constants.SOURCE_NAMES.CUSTOM,
  categories: ['API', 'Custom'],
  serviceType: 'custom',
  configuration: {
    hasOauthRedirect: false,
    needsBaseUrl: false,
    documentationUrl: _doc_links.docLinks.workplaceSearchCustomSources,
    applicationPortalUrl: ''
  },
  accountContextOnly: false
};
const getSourceData = (serviceType, baseServiceType) => {
  if (serviceType === 'custom' && typeof baseServiceType === 'undefined') {
    return staticCustomSourceData;
  }
  return staticSourceData.find(staticSource => staticSource.serviceType === serviceType && staticSource.baseServiceType === baseServiceType);
};
exports.getSourceData = getSourceData;
const hasExternalConnectorOption = serviceType => !!getSourceData('external', serviceType);
exports.hasExternalConnectorOption = hasExternalConnectorOption;
const hasCustomConnectorOption = serviceType => !!getSourceData('custom', serviceType);
exports.hasCustomConnectorOption = hasCustomConnectorOption;
const hasMultipleConnectorOptions = serviceType => hasExternalConnectorOption(serviceType) || hasCustomConnectorOption(serviceType);
exports.hasMultipleConnectorOptions = hasMultipleConnectorOptions;