"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddCustomSource = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _app_logic = require("../../../../../app_logic");
var _layout = require("../../../../../components/layout");
var _constants = require("../../../../../constants");
var _source_data = require("../../../source_data");
var _add_custom_source_logic = require("./add_custom_source_logic");
var _configure_custom = require("./configure_custom");
var _save_custom = require("./save_custom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddCustomSource = () => {
  const {
    baseServiceType
  } = (0, _reactRouterDom.useParams)();
  const sourceData = (0, _source_data.getSourceData)('custom', baseServiceType);
  const addCustomSourceLogic = (0, _add_custom_source_logic.AddCustomSourceLogic)({
    baseServiceType,
    initialValue: sourceData === null || sourceData === void 0 ? void 0 : sourceData.name
  });
  const {
    currentStep
  } = (0, _kea.useValues)(addCustomSourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  if (!sourceData) {
    return null;
  }
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE, sourceData.name]
  }, currentStep === _add_custom_source_logic.AddCustomSourceSteps.ConfigureCustomStep && /*#__PURE__*/_react.default.createElement(_configure_custom.ConfigureCustom, {
    sourceData: sourceData
  }), currentStep === _add_custom_source_logic.AddCustomSourceSteps.SaveCustomStep && /*#__PURE__*/_react.default.createElement(_save_custom.SaveCustom, {
    sourceData: sourceData
  }));
};
exports.AddCustomSource = AddCustomSource;