"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchHeaderActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _enterprise_search_url = require("../../../shared/enterprise_search_url");
var _endpoints_header_action = require("../../../shared/layout/endpoints_header_action");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _constants = require("../../constants");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkplaceSearchHeaderActions = () => {
  if (!_enterprise_search_url.externalUrl.enterpriseSearchUrl) return null;
  return /*#__PURE__*/_react.default.createElement(_endpoints_header_action.EndpointsHeaderAction, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    "data-test-subj": "PersonalDashboardButton",
    iconType: "user",
    to: _routes.PRIVATE_SOURCES_PATH,
    size: "s"
  }, _constants.NAV.PERSONAL_DASHBOARD)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "HeaderSearchButton",
    href: (0, _enterprise_search_url.getWorkplaceSearchUrl)('/search'),
    target: "_blank",
    iconType: "search",
    size: "s"
  }, _constants.NAV.SEARCH))));
};
exports.WorkplaceSearchHeaderActions = WorkplaceSearchHeaderActions;