"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _enterprise_search_url = require("../../../../shared/enterprise_search_url");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _app_logic = require("../../../app_logic");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccountHeader = () => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const {
    account: {
      isAdmin
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const accountNavItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "accountSettings"
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    to: _routes.PERSONAL_SETTINGS_PATH
  }, _constants.ACCOUNT_NAV.SETTINGS)), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "logout"
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    to: _routes.LOGOUT_ROUTE,
    shouldNotCreateHref: true
  }, _constants.ACCOUNT_NAV.LOGOUT))];
  const accountButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "data-test-subj": "AccountButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick
  }, _constants.ACCOUNT_NAV.ACCOUNT);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLogo, {
    iconType: "logoWorkplaceSearch"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    role: "banner"
  }, _constants.WORKPLACE_SEARCH_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    to: _routes.PRIVATE_SOURCES_PATH
  }, _constants.ACCOUNT_NAV.SOURCES)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    grow: false,
    side: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, isAdmin && /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    to: "/"
  }, _constants.ACCOUNT_NAV.ORG_DASHBOARD), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "accountSubNav",
    button: accountButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: accountNavItems
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: (0, _enterprise_search_url.getWorkplaceSearchUrl)('/search'),
    target: "_blank",
    iconType: "search"
  }, _constants.ACCOUNT_NAV.SEARCH))));
};
exports.AccountHeader = AccountHeader;