"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaAddFieldModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _2 = require("..");
var _constants = require("../../constants");
var _constants2 = require("../constants");
var _types = require("../types");
var _constants3 = require("./constants");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaAddFieldModal = ({
  addNewField,
  addFieldFormErrors,
  closeAddFieldModal,
  disableForm
}) => {
  const [loading, setLoading] = (0, _react.useState)(false);
  const [newFieldType, updateNewFieldType] = (0, _react.useState)(_types.SchemaType.Text);
  const [formattedFieldName, setFormattedFieldName] = (0, _react.useState)('');
  const [rawFieldName, setRawFieldName] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (addFieldFormErrors) setLoading(false);
  }, [addFieldFormErrors]);
  const handleChange = ({
    currentTarget: {
      value
    }
  }) => {
    setRawFieldName(value);
    setFormattedFieldName((0, _utils.formatFieldName)(value));
  };
  const submitForm = e => {
    e.preventDefault();
    addNewField(formattedFieldName, newFieldType);
    setLoading(true);
  };
  const fieldNameNote = rawFieldName !== formattedFieldName ? (0, _constants3.FIELD_NAME_CORRECTED_NOTE)(formattedFieldName) : _constants3.FIELD_NAME_CORRECT_NOTE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeAddFieldModal,
    maxWidth: 500
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _constants3.ADD_FIELD_MODAL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    iconType: "iInCircle",
    title: /*#__PURE__*/_react.default.createElement("p", null, _constants3.ADD_FIELD_MODAL_DESCRIPTION)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: _constants3.FORM_ID,
    onSubmit: submitForm
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.FIELD_NAME,
    helpText: fieldNameNote,
    fullWidth: true,
    "data-test-subj": "SchemaAddFieldNameRow",
    error: /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textBreakAll"
    }, addFieldFormErrors),
    isInvalid: !!addFieldFormErrors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _constants3.FIELD_NAME_PLACEHOLDER,
    onChange: handleChange,
    value: rawFieldName,
    fullWidth: true,
    autoFocus: true,
    required: true,
    isLoading: loading,
    disabled: disableForm,
    "data-test-subj": "SchemaAddFieldNameField"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.FIELD_TYPE,
    "data-test-subj": "SchemaAddFieldTypeRow"
  }, /*#__PURE__*/_react.default.createElement(_2.SchemaFieldTypeSelect, {
    fieldName: "",
    fieldType: newFieldType,
    updateExistingFieldType: (_, type) => updateNewFieldType(type),
    disabled: disableForm,
    "data-test-subj": "SchemaSelect"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeAddFieldModal
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: _constants3.FORM_ID,
    isLoading: loading,
    disabled: disableForm,
    "data-test-subj": "SchemaAddFieldButton"
  }, _constants3.ADD_FIELD_BUTTON)));
};
exports.SchemaAddFieldModal = SchemaAddFieldModal;