"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNavLinkActive = exports.generateNavLink = void 0;
var _strip_slashes = require("../../../../common/strip_slashes");
var _kibana = require("../kibana");
var _react_router_helpers = require("../react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateNavLink = ({
  items,
  ...rest
}) => {
  const linkProps = {
    ...(0, _react_router_helpers.generateReactRouterProps)({
      ...rest
    }),
    isSelected: getNavLinkActive({
      items,
      ...rest
    })
  };
  return items ? {
    ...linkProps,
    items
  } : linkProps;
};
exports.generateNavLink = generateNavLink;
const getNavLinkActive = ({
  to,
  shouldShowActiveForSubroutes = false,
  items = [],
  shouldNotCreateHref = false
}) => {
  const {
    pathname
  } = _kibana.KibanaLogic.values.history.location;
  const currentPath = (0, _strip_slashes.stripTrailingSlash)(pathname);
  const {
    href: currentPathHref
  } = (0, _react_router_helpers.generateReactRouterProps)({
    shouldNotCreateHref: false,
    to: currentPath
  });
  const {
    href: toHref
  } = (0, _react_router_helpers.generateReactRouterProps)({
    shouldNotCreateHref,
    to
  });
  if (currentPathHref === toHref) return true;
  if (shouldShowActiveForSubroutes) {
    if (items.length) return false; // If a nav link has sub-nav items open, never show it as active
    if (currentPathHref.startsWith(toHref)) return true;
  }
  return false;
};
exports.getNavLinkActive = getNavLinkActive;