"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnterpriseSearchNav = exports.useEnterpriseSearchApplicationNav = exports.useEnterpriseSearchAnalyticsNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _routes = require("../../applications/routes");
var _indices_nav = require("../../enterprise_search_content/components/search_index/indices/indices_nav");
var _routes2 = require("../../enterprise_search_content/routes");
var _routes3 = require("../../enterprise_search_relevance/routes");
var _kibana = require("../kibana");
var _licensing = require("../licensing");
var _nav_link_helpers = require("./nav_link_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to generate the Enterprise Search navigation items
 *
 * @param alwaysReturn Flag to always return the nav items, even if the sidebar is disabled
 * @returns The Enterprise Search navigation items
 */
const useEnterpriseSearchNav = (alwaysReturn = false) => {
  const {
    isSearchHomepageEnabled,
    searchHomepage,
    isSidebarEnabled,
    productAccess
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasEnterpriseLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const indicesNavItems = (0, _indices_nav.useIndicesNav)();
  if (!isSidebarEnabled && !alwaysReturn) return undefined;
  const navItems = [{
    id: 'home',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.nav.homeTitle', {
      defaultMessage: 'Home'
    })),
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: true,
      to: isSearchHomepageEnabled && searchHomepage ? searchHomepage.app.appRoute : _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL
    })
  }, {
    id: 'content',
    items: [{
      id: 'search_indices',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle', {
        defaultMessage: 'Indices'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        items: indicesNavItems,
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes2.SEARCH_INDICES_PATH
      })
    }, {
      id: 'connectors',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.connectorsTitle', {
        defaultMessage: 'Connectors'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes2.CONNECTORS_PATH
      })
    }, {
      id: 'crawlers',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.crawlersTitle', {
        defaultMessage: 'Web crawlers'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes2.CRAWLERS_PATH
      })
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.contentTitle', {
      defaultMessage: 'Content'
    })
  }, {
    id: 'build',
    items: [{
      id: 'playground',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.PlaygroundTitle', {
        defaultMessage: 'Playground'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.APPLICATIONS_PLUGIN.URL + _routes.PLAYGROUND_PATH
      })
    }, {
      id: 'searchApplications',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplicationsTitle', {
        defaultMessage: 'Search Applications'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.APPLICATIONS_PLUGIN.URL + _routes.SEARCH_APPLICATIONS_PATH
      })
    }, {
      id: 'analyticsCollections',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsTitle', {
        defaultMessage: 'Behavioral Analytics'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL
      })
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.applicationsTitle', {
      defaultMessage: 'Build'
    })
  }, ...(hasEnterpriseLicense ? [{
    id: 'relevance',
    items: [{
      id: 'inference_endpoints',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.inferenceEndpointsTitle', {
        defaultMessage: 'Inference Endpoints'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: _constants.INFERENCE_ENDPOINTS_PLUGIN.URL + _routes3.INFERENCE_ENDPOINTS_PATH
      })
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.relevanceTitle', {
      defaultMessage: 'Relevance'
    })
  }] : []), {
    id: 'es_getting_started',
    items: [{
      id: 'elasticsearch',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.elasticsearchTitle', {
        defaultMessage: 'Elasticsearch'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ELASTICSEARCH_PLUGIN.URL
      })
    }, {
      id: 'vectorSearch',
      name: _constants.VECTOR_SEARCH_PLUGIN.NAME,
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.VECTOR_SEARCH_PLUGIN.URL
      })
    }, {
      id: 'semanticSearch',
      name: _constants.SEMANTIC_SEARCH_PLUGIN.NAME,
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.SEMANTIC_SEARCH_PLUGIN.URL
      })
    }, {
      id: 'aiSearch',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.aiSearchTitle', {
        defaultMessage: 'AI Search'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.AI_SEARCH_PLUGIN.URL
      })
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.enterpriseSearchOverviewTitle', {
      defaultMessage: 'Getting started'
    })
  }, ...(productAccess.hasAppSearchAccess || productAccess.hasWorkplaceSearchAccess ? [{
    id: 'enterpriseSearch',
    items: [...(productAccess.hasAppSearchAccess ? [{
      id: 'app_search',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.appSearchTitle', {
        defaultMessage: 'App Search'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.APP_SEARCH_PLUGIN.URL
      })
    }] : []), ...(productAccess.hasWorkplaceSearchAccess ? [{
      id: 'workplace_search',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.workplaceSearchTitle', {
        defaultMessage: 'Workplace Search'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.WORKPLACE_SEARCH_PLUGIN.URL
      })
    }] : [])],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.title', {
      defaultMessage: 'Enterprise Search'
    })
  }] : [])];
  return navItems;
};
exports.useEnterpriseSearchNav = useEnterpriseSearchNav;
const useEnterpriseSearchApplicationNav = (searchApplicationName, isEmptyState, hasSchemaConflicts, alwaysReturn) => {
  var _applicationsItem$ite;
  const navItems = useEnterpriseSearchNav(alwaysReturn);
  if (!navItems) return undefined;
  if (!searchApplicationName) return navItems;
  const applicationsItem = navItems.find(item => item.id === 'build');
  if (!applicationsItem || !applicationsItem.items) return navItems;
  const searchApplicationsItem = (_applicationsItem$ite = applicationsItem.items) === null || _applicationsItem$ite === void 0 ? void 0 : _applicationsItem$ite.find(item => item.id === 'searchApplications');
  if (!searchApplicationsItem || searchApplicationsItem.id !== 'searchApplications') return navItems;
  const searchApplicationPath = `${_constants.APPLICATIONS_PLUGIN.URL}${_routes.SEARCH_APPLICATIONS_PATH}/${searchApplicationName}`;
  searchApplicationsItem.items = !isEmptyState ? [{
    id: 'searchApplicationId',
    name: searchApplicationName,
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: false,
      to: searchApplicationPath
    }),
    items: [{
      id: 'enterpriseSearchApplicationDocsExplorer',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplication.docsExplorerTitle', {
        defaultMessage: 'Docs Explorer'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: `${searchApplicationPath}/${_routes.SearchApplicationViewTabs.DOCS_EXPLORER}`
      })
    }, {
      // Required for the new side nav
      iconToString: hasSchemaConflicts ? 'warning' : undefined,
      id: 'enterpriseSearchApplicationsContent',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "center"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplication.contentTitle', {
        defaultMessage: 'Content'
      }), hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "danger"
      })),
      // Required for the new side nav
      nameToString: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchApplication.contentTitle', {
        defaultMessage: 'Content'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: `${searchApplicationPath}/${_routes.SearchApplicationViewTabs.CONTENT}`
      })
    }, {
      id: 'enterpriseSearchApplicationConnect',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.applications.searchApplications.connectTitle', {
        defaultMessage: 'Connect'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        shouldShowActiveForSubroutes: true,
        to: `${searchApplicationPath}/${_routes.SearchApplicationViewTabs.CONNECT}`
      })
    }]
  }] : [{
    id: 'searchApplicationId',
    name: searchApplicationName,
    ...(0, _nav_link_helpers.generateNavLink)({
      shouldNotCreateHref: true,
      shouldShowActiveForSubroutes: true,
      to: searchApplicationPath
    })
  }];
  return navItems;
};
exports.useEnterpriseSearchApplicationNav = useEnterpriseSearchApplicationNav;
const useEnterpriseSearchAnalyticsNav = (name, paths, alwaysReturn) => {
  var _applicationsNav$item;
  const navItems = useEnterpriseSearchNav(alwaysReturn);
  if (!navItems) return undefined;
  const applicationsNav = navItems.find(item => item.id === 'build');
  const analyticsNav = applicationsNav === null || applicationsNav === void 0 ? void 0 : (_applicationsNav$item = applicationsNav.items) === null || _applicationsNav$item === void 0 ? void 0 : _applicationsNav$item.find(item => item.id === 'analyticsCollections');
  if (!name || !paths || !analyticsNav) return navItems;
  analyticsNav.items = [{
    id: 'analyticsCollection',
    items: [{
      id: 'analyticsCollectionOverview',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.overviewTitle', {
        defaultMessage: 'Overview'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL + paths.overview
      })
    }, {
      id: 'analyticsCollectionExplorer',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.explorerTitle', {
        defaultMessage: 'Explorer'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL + paths.explorer
      })
    }, {
      id: 'analyticsCollectionIntegration',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.analyticsCollections.integrationTitle', {
        defaultMessage: 'Integration'
      }),
      ...(0, _nav_link_helpers.generateNavLink)({
        shouldNotCreateHref: true,
        to: _constants.ANALYTICS_PLUGIN.URL + paths.integration
      })
    }],
    name
  }];
  return navItems;
};
exports.useEnterpriseSearchAnalyticsNav = useEnterpriseSearchAnalyticsNav;