"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepagePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _kibana = require("../../shared/kibana");
var _kibana_chrome = require("../../shared/kibana_chrome");
var _page_template = require("./layout/page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchHomepagePage = () => {
  const {
    isSearchHomepageEnabled,
    searchHomepage
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  if (!isSearchHomepageEnabled || !searchHomepage) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.SearchHomepagePageTemplate, {
    restrictWidth: false,
    grow: false,
    offset: 0,
    pageViewTelemetry: "searchHomepage"
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetSearchChrome, null), /*#__PURE__*/_react.default.createElement(searchHomepage.SearchHomepage, null));
};
exports.SearchHomepagePage = SearchHomepagePage;