"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestionCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IngestionCard = ({
  buttonIcon,
  buttonLabel,
  description,
  href,
  isDisabled,
  logo,
  onClick,
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    isDisabled: isDisabled,
    textAlign: "left",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: logo,
      size: "xxl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, description),
    footer: onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isDisabled,
      iconType: buttonIcon,
      onClick: onClick,
      fullWidth: true
    }, buttonLabel) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: href !== null && href !== void 0 ? href : '',
      shouldNotCreateHref: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isDisabled,
      iconType: buttonIcon,
      fullWidth: true
    }, buttonLabel))
  });
};
exports.IngestionCard = IngestionCard;