"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexTabId = exports.SearchIndex = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _error_state = require("../../../shared/error_state");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _indices = require("../../utils/indices");
var _connector_configuration = require("../connector_detail/connector_configuration");
var _page_template = require("../layout/page_template");
var _search_indices = require("../search_indices");
var _header_actions = require("../shared/header_actions/header_actions");
var _connector_scheduling = require("./connector/connector_scheduling");
var _connector_rules = require("./connector/sync_rules/connector_rules");
var _automatic_crawl_scheduler = require("./crawler/automatic_crawl_scheduler/automatic_crawl_scheduler");
var _crawl_custom_settings_flyout = require("./crawler/crawl_custom_settings_flyout/crawl_custom_settings_flyout");
var _crawler_configuration = require("./crawler/crawler_configuration/crawler_configuration");
var _domain_management = require("./crawler/domain_management/domain_management");
var _no_connector_record = require("./crawler/no_connector_record");
var _documents = require("./documents");
var _index_error = require("./index_error");
var _index_mappings = require("./index_mappings");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
var _indices_nav = require("./indices/indices_nav");
var _overview = require("./overview");
var _pipelines = require("./pipelines/pipelines");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SearchIndexTabId = exports.SearchIndexTabId = /*#__PURE__*/function (SearchIndexTabId) {
  SearchIndexTabId["OVERVIEW"] = "overview";
  SearchIndexTabId["DOCUMENTS"] = "documents";
  SearchIndexTabId["INDEX_MAPPINGS"] = "index_mappings";
  SearchIndexTabId["PIPELINES"] = "pipelines";
  SearchIndexTabId["CONFIGURATION"] = "configuration";
  SearchIndexTabId["SYNC_RULES"] = "sync_rules";
  SearchIndexTabId["SCHEDULING"] = "scheduling";
  SearchIndexTabId["DOMAIN_MANAGEMENT"] = "domain_management";
  SearchIndexTabId["CRAWLER_CONFIGURATION"] = "crawler_configuration";
  return SearchIndexTabId;
}({});
const SearchIndex = () => {
  const {
    hasFilteringFeature,
    index,
    isInitialLoading
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    tabId = SearchIndexTabId.OVERVIEW
  } = (0, _reactRouterDom.useParams)();
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);

  /**
   * Guided Onboarding needs us to mark the add data step as complete as soon as the user has data in an index.
   * This needs to be checked for any of the 3 registered search guideIds
   * Putting it here guarantees that if a user is viewing an index with data, it'll be marked as complete
   */
  const {
    config,
    guidedOnboarding,
    productFeatures: {
      hasDefaultIngestPipeline
    },
    updateSideNavDefinition
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const indicesItems = (0, _indices_nav.useIndicesNav)();
  (0, _react.useEffect)(() => {
    var _guidedOnboarding$gui;
    const subscription = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui === void 0 ? void 0 : _guidedOnboarding$gui.isGuideStepActive$('appSearch', 'add_data').subscribe(isStepActive => {
      if (isStepActive && index !== null && index !== void 0 && index.count) {
        var _guidedOnboarding$gui2;
        guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.completeGuideStep('appSearch', 'add_data');
      }
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [guidedOnboarding, index === null || index === void 0 ? void 0 : index.count]);
  (0, _react.useEffect)(() => {
    var _guidedOnboarding$gui3;
    const subscription = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui3 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui3 === void 0 ? void 0 : _guidedOnboarding$gui3.isGuideStepActive$('websiteSearch', 'add_data').subscribe(isStepActive => {
      if (isStepActive && index !== null && index !== void 0 && index.count) {
        var _guidedOnboarding$gui4;
        guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui4 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui4 === void 0 ? void 0 : _guidedOnboarding$gui4.completeGuideStep('websiteSearch', 'add_data');
      }
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [guidedOnboarding, index === null || index === void 0 ? void 0 : index.count]);
  (0, _react.useEffect)(() => {
    var _guidedOnboarding$gui5;
    const subscription = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui5 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui5 === void 0 ? void 0 : _guidedOnboarding$gui5.isGuideStepActive$('databaseSearch', 'add_data').subscribe(isStepActive => {
      if (isStepActive && index !== null && index !== void 0 && index.count) {
        var _guidedOnboarding$gui6;
        (_guidedOnboarding$gui6 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui6 === void 0 ? void 0 : _guidedOnboarding$gui6.completeGuideStep('databaseSearch', 'add_data');
      }
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [guidedOnboarding, index === null || index === void 0 ? void 0 : index.count]);
  (0, _react.useEffect)(() => {
    // We update the new side nav definition with the selected indices items
    updateSideNavDefinition({
      indices: indicesItems
    });
  }, [indicesItems, updateSideNavDefinition]);
  (0, _react.useEffect)(() => {
    return () => {
      updateSideNavDefinition({
        indices: undefined
      });
    };
  }, [updateSideNavDefinition]);
  const ALL_INDICES_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_overview.SearchIndexOverview, null),
    'data-test-subj': 'entSearchContent-index-overview-tab',
    id: SearchIndexTabId.OVERVIEW,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.overviewTabLabel', {
      defaultMessage: 'Overview'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_documents.SearchIndexDocuments, null),
    id: SearchIndexTabId.DOCUMENTS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documentsTabLabel', {
      defaultMessage: 'Documents'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_index_mappings.SearchIndexIndexMappings, null),
    id: SearchIndexTabId.INDEX_MAPPINGS,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.indexMappingsTabLabel', {
      defaultMessage: 'Index mappings'
    })
  }];
  const CONNECTOR_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfiguration, null),
    id: SearchIndexTabId.CONFIGURATION,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.configurationTabLabel', {
      defaultMessage: 'Configuration'
    })
  }, ...(hasFilteringFeature ? [{
    content: /*#__PURE__*/_react.default.createElement(_connector_rules.ConnectorSyncRules, null),
    id: SearchIndexTabId.SYNC_RULES,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.syncRulesTabLabel', {
      defaultMessage: 'Sync rules'
    })
  }] : []), {
    content: /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorScheduling, null),
    id: SearchIndexTabId.SCHEDULING,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.schedulingTabLabel', {
      defaultMessage: 'Scheduling'
    })
  }];
  const CRAWLER_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_domain_management.SearchIndexDomainManagement, null),
    id: SearchIndexTabId.DOMAIN_MANAGEMENT,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.domainManagementTabLabel', {
      defaultMessage: 'Manage Domains'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_crawler_configuration.CrawlerConfiguration, null),
    id: SearchIndexTabId.CRAWLER_CONFIGURATION,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.crawlerConfigurationTabLabel', {
      defaultMessage: 'Configuration'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_automatic_crawl_scheduler.AutomaticCrawlScheduler, null),
    'data-test-subj': 'entSearchContent-index-crawler-scheduler-tab',
    id: SearchIndexTabId.SCHEDULING,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.schedulingTabLabel', {
      defaultMessage: 'Scheduling'
    })
  }];
  const PIPELINES_TAB = {
    content: /*#__PURE__*/_react.default.createElement(_pipelines.SearchIndexPipelines, null),
    id: SearchIndexTabId.PIPELINES,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.pipelinesTabLabel', {
      defaultMessage: 'Pipelines'
    })
  };
  const tabs = [...ALL_INDICES_TABS, ...((0, _indices.isConnectorIndex)(index) ? CONNECTOR_TABS : []), ...((0, _indices.isCrawlerIndex)(index) ? CRAWLER_TABS : []), ...(hasDefaultIngestPipeline ? [PIPELINES_TAB] : [])];
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, indexName],
    pageViewTelemetry: tabId,
    isLoading: isInitialLoading,
    pageHeader: {
      pageTitle: indexName,
      rightSideGroupProps: {
        responsive: false
      },
      rightSideItems: (0, _header_actions.getHeaderActions)(index)
    }
  }, /*#__PURE__*/_react.default.createElement(_index_error.IndexError, {
    indexName: indexName
  }), /*#__PURE__*/_react.default.createElement(Content, {
    index: index,
    errorConnectingMessage: errorConnectingMessage,
    config: config,
    tabs: tabs,
    tabId: tabId
  }));
};
exports.SearchIndex = SearchIndex;
const Content = ({
  config,
  errorConnectingMessage,
  index,
  tabs,
  tabId
}) => {
  const selectedTab = (0, _react.useMemo)(() => tabs.find(tab => tab.id === tabId), [tabId]);
  const onTabClick = tab => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(tab.id === SearchIndexTabId.OVERVIEW ? _routes.SEARCH_INDEX_PATH : _routes.SEARCH_INDEX_TAB_PATH, {
      indexName: (index === null || index === void 0 ? void 0 : index.name) || '',
      tabId: tab.id
    }));
  };
  if ((0, _indices.isCrawlerIndex)(index) && !index.connector) {
    return /*#__PURE__*/_react.default.createElement(_no_connector_record.NoConnectorRecord, null);
  }
  if ((0, _indices.isCrawlerIndex)(index) && (Boolean(errorConnectingMessage) || !(config !== null && config !== void 0 && config.host))) {
    return /*#__PURE__*/_react.default.createElement(_error_state.ErrorStatePrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    selectedTab: selectedTab,
    onTabClick: onTabClick
  }), (0, _indices.isCrawlerIndex)(index) && /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout.CrawlCustomSettingsFlyout, null));
};