"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryPointsTableLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../../../shared/flash_messages");
var _crawler_domain_detail_logic = require("./crawler_domain_detail_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntryPointsTableLogic = exports.EntryPointsTableLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'crawler', 'entry_points_table'],
  actions: () => ({
    onAdd: (entryPoint, entryPoints) => ({
      entryPoint,
      entryPoints
    }),
    onDelete: (entryPoint, entryPoints) => ({
      entryPoint,
      entryPoints
    }),
    onUpdate: (entryPoint, entryPoints) => ({
      entryPoint,
      entryPoints
    })
  }),
  listeners: () => ({
    onAdd: ({
      entryPoints
    }) => {
      _crawler_domain_detail_logic.CrawlerDomainDetailLogic.actions.updateEntryPoints(entryPoints);
      (0, _flash_messages.clearFlashMessages)();
    },
    onDelete: ({
      entryPoint,
      entryPoints
    }) => {
      _crawler_domain_detail_logic.CrawlerDomainDetailLogic.actions.updateEntryPoints(entryPoints);
      (0, _flash_messages.clearFlashMessages)();
      (0, _flash_messages.flashSuccessToast)(`Entry point "${entryPoint.value}" was removed.`);
    },
    onUpdate: ({
      entryPoints
    }) => {
      _crawler_domain_detail_logic.CrawlerDomainDetailLogic.actions.updateEntryPoints(entryPoints);
      (0, _flash_messages.clearFlashMessages)();
    }
  })
});