"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRunFromDockerSnippet = exports.getConnectorTemplate = void 0;
var _dedent = _interopRequireDefault(require("dedent"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorTemplate = ({
  apiKeyData,
  connectorData,
  host
}) => (0, _dedent.default)`connectors:
  -
    connector_id: "${connectorData.id}"
    service_type: "${connectorData.service_type || 'changeme'}"${apiKeyData !== null && apiKeyData !== void 0 && apiKeyData.encoded ? `
    api_key: "${apiKeyData === null || apiKeyData === void 0 ? void 0 : apiKeyData.encoded}"` : ''}

  elasticsearch:
    host: "${host || 'http://localhost:9200'}"
    api_key: "${(apiKeyData === null || apiKeyData === void 0 ? void 0 : apiKeyData.encoded) || ''}"
`;
exports.getConnectorTemplate = getConnectorTemplate;
const getRunFromDockerSnippet = ({
  version
}) => (0, _dedent.default)`
docker run \\

    -v "</absolute/path/to>/connectors-config:/config" \ # NOTE: change absolute path to match where config.yml is located on your machine
    --tty \\

    --rm \\

    docker.elastic.co/enterprise-search/elastic-connectors:${version} \\

    /app/bin/elastic-ingest \\

    -c /config/config.yml # Path to your configuration file in the container
`;
exports.getRunFromDockerSnippet = getRunFromDockerSnippet;