"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateApiKeyModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../../shared/doc_links");
var _generate_api_key_logic = require("../../../../api/generate_api_key/generate_api_key_logic");
var _index_view_logic = require("../../index_view_logic");
var _generate_api_key_modal = require("./generate_api_key_modal.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateApiKeyModal = ({
  indexName,
  onClose
}) => {
  const {
    keyName,
    apiKey,
    isLoading,
    isSuccess
  } = (0, _kea.useValues)(_generate_api_key_modal.GenerateApiKeyModalLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    setKeyName
  } = (0, _kea.useActions)(_generate_api_key_modal.GenerateApiKeyModalLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_generate_api_key_logic.GenerateApiKeyLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.title', {
    defaultMessage: 'Generate API Key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.info', {
    defaultMessage: "Before you can start posting documents to your Elasticsearch index you'll need to create at least one API key."
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.apiKeys,
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.learnMore', {
    defaultMessage: 'Learn more about API keys'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexEnd"
  }, !isSuccess ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Name your API key",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKey-editName`,
    fullWidth: true,
    placeholder: "Type a name for your API key",
    onChange: event => setKeyName(event.currentTarget.value),
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKey-generate `,
    "data-test-subj": "generateApiKeyButton",
    iconSide: "left",
    iconType: "plusInCircle",
    fill: true,
    onClick: () => {
      makeRequest({
        indexName,
        keyName: keyName.trim()
      });
    },
    disabled: keyName.trim().length <= 0
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.generateButton', {
    defaultMessage: 'Generate API key'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, keyName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": keyName,
    fontSize: "m",
    paddingSize: "m",
    color: "dark",
    isCopyable: true
  }, apiKey)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKey-download`,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.csvDownloadButton', {
      defaultMessage: 'Download API key'
    }),
    iconType: "download",
    href: encodeURI(`data:text/csv;charset=utf-8,${apiKey}`),
    download: `${keyName}.csv`
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "#006bb8"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.apiKeyWarning', {
    defaultMessage: "Elastic does not store API keys. Once generated, you'll only be able to view the key one time. Make sure you save it somewhere secure. If you lose access to it you'll need to generate a new API key from this screen."
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKey-cancel`,
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.generateApiKeyModal.cancel', {
    defaultMessage: 'Cancel'
  }))));
};
exports.GenerateApiKeyModal = GenerateApiKeyModal;