"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIVERSAL_LANGUAGE_VALUE = exports.SUPPORTED_LANGUAGES = exports.NEW_INDEX_TEMPLATE_TYPES = exports.DOCUMENTS_API_JSON_EXAMPLE = void 0;
var _i18n = require("@kbn/i18n");
var _language_to_text = require("../../utils/language_to_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_INDEX_TEMPLATE_TYPES = exports.NEW_INDEX_TEMPLATE_TYPES = {
  api: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.types.api', {
    defaultMessage: 'API endpoint'
  }),
  connector: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.types.connector', {
    defaultMessage: 'Connector'
  }),
  crawler: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.types.crawler', {
    defaultMessage: 'Web crawler'
  }),
  elasticsearch: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.types.elasticsearch', {
    defaultMessage: 'Elasticsearch index'
  }),
  json: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.types.json', {
    defaultMessage: 'JSON'
  })
};
const DOCUMENTS_API_JSON_EXAMPLE = exports.DOCUMENTS_API_JSON_EXAMPLE = {
  id: 'park_rocky-mountain',
  title: 'Rocky Mountain',
  description: 'Bisected north to south by the Continental Divide, this portion of the Rockies has ecosystems varying from over 150 riparian lakes to montane and subalpine forests to treeless alpine tundra. Wildlife including mule deer, bighorn sheep, black bears, and cougars inhabit its igneous mountains and glacial valleys. Longs Peak, a classic Colorado fourteener, and the scenic Bear Lake are popular destinations, as well as the historic Trail Ridge Road, which reaches an elevation of more than 12,000 feet (3,700 m).',
  nps_link: 'https://www.nps.gov/romo/index.htm',
  states: ['Colorado'],
  visitors: 4517585,
  world_heritage_site: false,
  location: '40.4,-105.58',
  acres: 265795.2,
  square_km: 1075.6,
  date_established: '1915-01-26T06:00:00Z'
};
const UNIVERSAL_LANGUAGE_VALUE = exports.UNIVERSAL_LANGUAGE_VALUE = '';
const SUPPORTED_LANGUAGES = exports.SUPPORTED_LANGUAGES = [{
  text: (0, _language_to_text.languageToText)(UNIVERSAL_LANGUAGE_VALUE),
  value: UNIVERSAL_LANGUAGE_VALUE
}, {
  disabled: true,
  text: '—'
}, {
  text: (0, _language_to_text.languageToText)('zh'),
  value: 'zh'
}, {
  text: (0, _language_to_text.languageToText)('da'),
  value: 'da'
}, {
  text: (0, _language_to_text.languageToText)('nl'),
  value: 'nl'
}, {
  text: (0, _language_to_text.languageToText)('en'),
  value: 'en'
}, {
  text: (0, _language_to_text.languageToText)('fr'),
  value: 'fr'
}, {
  text: (0, _language_to_text.languageToText)('de'),
  value: 'de'
}, {
  text: (0, _language_to_text.languageToText)('it'),
  value: 'it'
}, {
  text: (0, _language_to_text.languageToText)('ja'),
  value: 'ja'
}, {
  text: (0, _language_to_text.languageToText)('ko'),
  value: 'ko'
}, {
  text: (0, _language_to_text.languageToText)('pt'),
  value: 'pt'
}, {
  text: (0, _language_to_text.languageToText)('pt-br'),
  value: 'pt-br'
}, {
  text: (0, _language_to_text.languageToText)('ru'),
  value: 'ru'
}, {
  text: (0, _language_to_text.languageToText)('es'),
  value: 'es'
}, {
  text: (0, _language_to_text.languageToText)('th'),
  value: 'th'
}];