"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConnectorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _lodash = require("lodash");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _connectors_logic = require("./connectors_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteConnectorModal = ({
  isCrawler
}) => {
  const [connectorUiOptions, setConnectorUiOptions] = (0, _useLocalStorage.default)('search:connector-ui-options', {});
  const {
    closeDeleteModal,
    deleteConnector,
    deleteIndex
  } = (0, _kea.useActions)(_connectors_logic.ConnectorsLogic);
  const {
    deleteModalConnectorId: connectorId,
    deleteModalConnectorName,
    deleteModalIndexName,
    isDeleteLoading,
    isDeleteModalVisible
  } = (0, _kea.useValues)(_connectors_logic.ConnectorsLogic);
  const connectorName = isCrawler ? deleteModalIndexName : deleteModalConnectorName;
  const [inputConnectorName, setInputConnectorName] = (0, _react.useState)('');
  const [shouldDeleteIndex, setShouldDeleteIndex] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setShouldDeleteIndex(false);
    setInputConnectorName('');
  }, [isDeleteModalVisible, isCrawler]);
  return isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.title', {
      defaultMessage: 'Delete {connectorCount} connector?',
      values: {
        connectorCount: 1
      }
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.crawlers.deleteModal.title', {
      defaultMessage: 'Delete {connectorCount} crawler?',
      values: {
        connectorCount: 1
      }
    }),
    onCancel: () => {
      closeDeleteModal();
    },
    onConfirm: () => {
      if (isCrawler) {
        if (deleteModalIndexName) {
          deleteIndex({
            indexName: deleteModalIndexName
          });
        }
      } else {
        deleteConnector({
          connectorId,
          shouldDeleteIndex
        });
        setConnectorUiOptions((0, _lodash.omit)(connectorUiOptions, connectorId));
      }
    },
    cancelButtonText: isDeleteLoading ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.closeButton.title', {
      defaultMessage: 'Close'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.cancelButton.title', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.confirmButton.title', {
      defaultMessage: 'Delete'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    confirmButtonDisabled: inputConnectorName.trim() !== connectorName,
    isLoading: isDeleteLoading
  }, /*#__PURE__*/_react.default.createElement("p", null, !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.delete.connector.description', {
    defaultMessage: 'You are about to delete this connector:'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.delete.crawler.description', {
    defaultMessage: 'You are about to delete this crawler:'
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.deleteConnectorModal.li.myconnectornameRelatedIndexLabel",
    defaultMessage: "{connectorName} (Related index: {deleteModalIndexName} )",
    values: {
      connectorName,
      deleteModalIndexName: deleteModalIndexName || '-'
    }
  })))), /*#__PURE__*/_react.default.createElement("p", null, isCrawler && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.deleteConnectorModal.crawler.warning",
    defaultMessage: "Deleting this crawler will also delete its related index with all of its data and its Crawler configuration. Any associated search applications will no longer be able to access any data stored in this index. This action cannot be undone. Please type {connectorName} to confirm.",
    values: {
      connectorName: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "danger"
      }, connectorName))
    }
  })), !isCrawler && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connectors.deleteModal.syncsWarning.indexNameDescription",
    defaultMessage: "This action cannot be undone. Please type {connectorName} to confirm.",
    values: {
      connectorName: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "danger"
      }, connectorName))
    }
  }))), deleteModalIndexName && !isCrawler && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "delete-related-index",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.deleteConnectorModal.euiCheckbox.deleteAlsoRelatedIndexLabel', {
      defaultMessage: 'Also delete related index'
    }),
    checked: shouldDeleteIndex,
    onChange: () => setShouldDeleteIndex(!shouldDeleteIndex)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.connector.indexNameInput.label', {
      defaultMessage: 'Connector name'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.deleteModal.crawler.indexNameInput.label', {
      defaultMessage: 'Crawler name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entSearchContent-connectors-deleteModal-input",
    "data-telemetry-id": "entSearchContent-connectors-deleteModal-input",
    onChange: e => setInputConnectorName(e.target.value),
    value: inputConnectorName
  })))) : null;
};
exports.DeleteConnectorModal = DeleteConnectorModal;