"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _connector_detail_router = require("../connector_detail/connector_detail_router");
var _new_search_index_page = require("../new_index/new_search_index_page");
var _connectors = require("./connectors");
var _select_connector = require("./select_connector/select_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsRouter = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.NEW_INDEX_SELECT_CONNECTOR_PATH
  }, /*#__PURE__*/_react.default.createElement(_select_connector.SelectConnector, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.NEW_CONNECTOR_PATH
  }, /*#__PURE__*/_react.default.createElement(_new_search_index_page.NewSearchIndexPage, {
    type: "connector"
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTORS_PATH,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    isCrawler: false
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTOR_DETAIL_PATH
  }, /*#__PURE__*/_react.default.createElement(_connector_detail_router.ConnectorDetailRouter, null)));
};
exports.ConnectorsRouter = ConnectorsRouter;