"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.crawlersBreadcrumbs = exports.connectorsBreadcrumbs = exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _table_pagination = require("../../../shared/table_pagination");
var _routes = require("../../routes");
var _layout = require("../layout");
var _cannot_connect = require("../search_index/components/cannot_connect");
var _default_settings_flyout = require("../settings/default_settings_flyout");
var _connector_stats = require("./connector_stats");
var _connectors_logic = require("./connectors_logic");
var _connectors_table = require("./connectors_table");
var _crawler_empty_state = require("./crawler_empty_state");
var _delete_connector_modal = require("./delete_connector_modal");
var _select_connector = require("./select_connector/select_connector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorsBreadcrumbs = exports.connectorsBreadcrumbs = [_i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.breadcrumb', {
  defaultMessage: 'Connectors'
})];
const crawlersBreadcrumbs = exports.crawlersBreadcrumbs = [_i18n.i18n.translate('xpack.enterpriseSearch.content.crawlers.breadcrumb', {
  defaultMessage: 'Web crawlers'
})];
const Connectors = ({
  isCrawler
}) => {
  const {
    fetchConnectors,
    onPaginate,
    setIsFirstRequest,
    openDeleteModal
  } = (0, _kea.useActions)(_connectors_logic.ConnectorsLogic);
  const {
    data,
    isLoading,
    searchParams,
    isEmpty,
    connectors
  } = (0, _kea.useValues)(_connectors_logic.ConnectorsLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const [searchQuery, setSearchValue] = (0, _react.useState)('');
  const [showMoreOptionsPopover, setShowMoreOptionsPopover] = (0, _react.useState)(false);
  const [showDefaultSettingsFlyout, setShowDefaultSettingsFlyout] = (0, _react.useState)(false);
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useEffect)(() => {
    setIsFirstRequest();
  }, [isCrawler]);
  (0, _react.useEffect)(() => {
    fetchConnectors({
      ...searchParams,
      fetchCrawlersOnly: isCrawler,
      searchQuery
    });
  }, [searchParams.from, searchParams.size, searchQuery, isCrawler]);
  return !isLoading && isEmpty && !isCrawler ? /*#__PURE__*/_react.default.createElement(_select_connector.SelectConnector, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_connector_modal.DeleteConnectorModal, {
    isCrawler: isCrawler
  }), /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchContentPageTemplate, {
    pageChrome: !isCrawler ? connectorsBreadcrumbs : crawlersBreadcrumbs,
    pageViewTelemetry: !isCrawler ? 'Connectors' : 'Web Crawlers',
    isLoading: isLoading,
    pageHeader: {
      pageTitle: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectors.title', {
        defaultMessage: 'Elasticsearch connectors'
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawlers.title', {
        defaultMessage: 'Elasticsearch web crawlers'
      }),
      rightSideGroupProps: {
        gutterSize: 's',
        responsive: false
      },
      rightSideItems: isLoading ? [] : !isCrawler ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "entSearchContent-connectors-newConnectorButton",
        "data-telemetry-id": "entSearchContent-connectors-newConnectorButton",
        key: "newConnector",
        color: "primary",
        iconType: "plusInCircle",
        fill: true,
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_PATH);
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.connectors.newConnectorButtonLabel",
        defaultMessage: "New Connector"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        isOpen: showMoreOptionsPopover,
        closePopover: () => setShowMoreOptionsPopover(false),
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": "entSearchContent-connectors-newConnector-moreOptionsButton",
          "data-telemetry-id": "entSearchContent-connectors-newConnector-moreOptionsButton",
          color: "primary",
          display: "fill",
          size: "m",
          iconType: "boxesVertical",
          "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectors.more.ariaLabel', {
            defaultMessage: 'More options'
          }),
          onClick: () => setShowMoreOptionsPopover(!showMoreOptionsPopover)
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        size: "s",
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          size: "s",
          key: "newConnectorNative",
          onClick: () => {
            _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_NATIVE_PATH);
          },
          icon: "plusInCircle"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newNativeConnectorButtonLabel', {
          defaultMessage: 'New Native Connector'
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          size: "s",
          key: "newConnectorClient",
          icon: "plusInCircle",
          onClick: () => {
            _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_CLIENTS_PATH);
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newConnectorsClientButtonLabel', {
          defaultMessage: 'New Connector Client'
        }))]
      })))), ...(productFeatures.hasDefaultIngestPipeline ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        "data-test-subj": "entSearchContent-searchIndices-defaultSettings",
        onClick: () => setShowDefaultSettingsFlyout(true)
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.defaultSettings', {
        defaultMessage: 'Default settings'
      }))] : [])] : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "entSearchContent-crawlers-newCrawlerButton",
        "data-telemetry-id": "entSearchContent-crawlers-newCrawlerButton",
        disabled: Boolean(errorConnectingMessage),
        key: "newCrawler",
        color: "primary",
        iconType: "plusInCircle",
        fill: true,
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_CRAWLER_PATH);
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newCrawlerButtonLabel', {
        defaultMessage: 'New web crawler'
      })), ...(productFeatures.hasDefaultIngestPipeline ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        "data-test-subj": "entSearchContent-connectors-defaultSettingsPopover",
        "data-telemetry-id": "entSearchContent-connectors-defaultSettingsPopover",
        onClick: () => setShowDefaultSettingsFlyout(true)
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.defaultSettings', {
        defaultMessage: 'Default settings'
      }))] : [])]
    }
  }, productFeatures.hasDefaultIngestPipeline && showDefaultSettingsFlyout && /*#__PURE__*/_react.default.createElement(_default_settings_flyout.DefaultSettingsFlyout, {
    closeFlyout: () => setShowDefaultSettingsFlyout(false)
  }), Boolean(errorConnectingMessage) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cannot_connect.CannotConnect, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_connector_stats.ConnectorStats, {
    isCrawler: isCrawler
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isEmpty && isCrawler ? /*#__PURE__*/_react.default.createElement(_crawler_empty_state.CrawlerEmptyState, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorsTable.h2.availableConnectorsLabel",
    defaultMessage: "Available connectors"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorsTable.h2.availableCrawlersLabel",
    defaultMessage: "Available web crawlers"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchQuery,
    box: {
      incremental: true,
      placeholder: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterConnectorsPlaceholder', {
        defaultMessage: 'Filter connectors'
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterCrawlersPlaceholder', {
        defaultMessage: 'Filter web crawlers'
      })
    },
    "aria-label": !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterConnectorsLabel', {
      defaultMessage: 'Filter connectors'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterCrawlersLabel', {
      defaultMessage: 'Filter web crawlers'
    }),
    onChange: event => setSearchValue(event.queryText)
  })), /*#__PURE__*/_react.default.createElement(_connectors_table.ConnectorsTable, {
    isCrawler: isCrawler,
    items: connectors || [],
    meta: data === null || data === void 0 ? void 0 : data.meta,
    onChange: (0, _table_pagination.handlePageChange)(onPaginate),
    onDelete: openDeleteModal
  })))));
};
exports.Connectors = Connectors;