"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDeployment = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _api = require("../../../../../common/types/api");
var _get_api_key_by_id_api_logic = require("../../api/api_key/get_api_key_by_id_api_logic");
var _generate_connector_api_key_api_logic = require("../../api/connector/generate_connector_api_key_api_logic");
var _connector_linked = require("./components/connector_linked");
var _docker_instructions_step = require("./components/docker_instructions_step");
var _generate_config_button = require("./components/generate_config_button");
var _generated_config_fields = require("./components/generated_config_fields");
var _run_from_source_step = require("./components/run_from_source_step");
var _run_options_buttons = require("./components/run_options_buttons");
var _waiting_for_connector_step = require("./components/waiting_for_connector_step");
var _connector_view_logic = require("./connector_view_logic");
var _deployment_logic = require("./deployment_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorDeployment = () => {
  var _connector$api_key_id, _connector$service_ty, _connector$service_ty2;
  const [selectedDeploymentMethod, setSelectedDeploymentMethod] = (0, _react.useState)('docker');
  const {
    generatedData,
    isGenerateLoading
  } = (0, _kea.useValues)(_deployment_logic.DeploymentLogic);
  const {
    index,
    isLoading,
    connector,
    connectorId
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    fetchConnector
  } = (0, _kea.useActions)(_connector_view_logic.ConnectorViewLogic);
  const {
    generateConfiguration
  } = (0, _kea.useActions)(_deployment_logic.DeploymentLogic);
  const {
    makeRequest: getApiKeyById
  } = (0, _kea.useActions)(_get_api_key_by_id_api_logic.GetApiKeyByIdLogic);
  const {
    data: apiKeyMetaData
  } = (0, _kea.useValues)(_get_api_key_by_id_api_logic.GetApiKeyByIdLogic);
  const {
    makeRequest: generateConnectorApiKey
  } = (0, _kea.useActions)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const {
    status,
    data: apiKeyData
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const [connectorUiOptions, setConnectorUiOptions] = (0, _useLocalStorage.default)('search:connector-ui-options', {});
  (0, _react.useEffect)(() => {
    if (connectorUiOptions && connectorId && connectorUiOptions[connectorId]) {
      setSelectedDeploymentMethod(connectorUiOptions[connectorId].deploymentMethod);
    } else {
      selectDeploymentMethod('docker');
    }
  }, [connectorUiOptions, connectorId]);
  (0, _react.useEffect)(() => {
    if (connectorId && connector && connector.api_key_id) {
      getApiKeyById(connector.api_key_id);
    }
  }, [connector, connectorId]);
  if (!connector || connector.is_native) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const selectDeploymentMethod = deploymentMethod => {
    setSelectedDeploymentMethod(deploymentMethod);
    setConnectorUiOptions({
      ...connectorUiOptions,
      [connector.id]: {
        deploymentMethod
      }
    });
  };
  const hasApiKey = !!((_connector$api_key_id = connector.api_key_id) !== null && _connector$api_key_id !== void 0 ? _connector$api_key_id : generatedData === null || generatedData === void 0 ? void 0 : generatedData.apiKey);
  const isWaitingForConnector = !connector.status || connector.status === _searchConnectors.ConnectorStatus.CREATED;
  const apiKey = (generatedData === null || generatedData === void 0 ? void 0 : generatedData.apiKey) || apiKeyData || apiKeyMetaData;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.DeploymentTitle', {
    defaultMessage: 'Deployment'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_run_options_buttons.RunOptionsButtons, {
        selectDeploymentMethod: selectDeploymentMethod,
        selectedDeploymentMethod: selectedDeploymentMethod
      }),
      status: selectedDeploymentMethod === null ? 'incomplete' : 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.runConnectorService.title', {
        defaultMessage: 'Run connector service'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, selectedDeploymentMethod === 'source' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.configureIndexAndApiKey.description.source",
        defaultMessage: "When you generate a configuration, Elastic will create an index, an API key and a Connector ID. You'll need to add this information to the {configYaml} file for your connector. Alternatively use an existing index and API key. ",
        values: {
          configYaml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorConfiguration.configymlCodeBlockLabel', {
            defaultMessage: 'config.yml'
          }))
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.configureIndexAndApiKey.description.docker",
        defaultMessage: "When you generate a configuration, Elastic will create an index, an API key and a Connector ID. Alternatively use an existing index and API key."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), hasApiKey && connector.index_name ? /*#__PURE__*/_react.default.createElement(_generated_config_fields.GeneratedConfigFields, {
        apiKey: apiKey,
        connector: connector,
        generateApiKey: () => {
          if (connector.index_name) {
            generateConnectorApiKey({
              indexName: connector.index_name,
              isNative: connector.is_native
            });
          }
        },
        isGenerateLoading: status === _api.Status.LOADING
      }) : /*#__PURE__*/_react.default.createElement(_generate_config_button.GenerateConfigButton, {
        connectorId: connector.id,
        generateConfiguration: generateConfiguration,
        isGenerateLoading: isGenerateLoading
      })),
      status: hasApiKey ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.generateApiKey.title', {
        defaultMessage: 'Configure index and API key'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), selectedDeploymentMethod === 'source' ? /*#__PURE__*/_react.default.createElement(_run_from_source_step.RunFromSourceStep, {
        connectorId: connectorId !== null && connectorId !== void 0 ? connectorId : '',
        serviceType: (_connector$service_ty = connector.service_type) !== null && _connector$service_ty !== void 0 ? _connector$service_ty : '',
        apiKeyData: apiKey,
        isWaitingForConnector: isWaitingForConnector
      }) : /*#__PURE__*/_react.default.createElement(_docker_instructions_step.DockerInstructionsStep, {
        connectorId: connectorId !== null && connectorId !== void 0 ? connectorId : '',
        hasApiKey: hasApiKey,
        serviceType: (_connector$service_ty2 = connector.service_type) !== null && _connector$service_ty2 !== void 0 ? _connector$service_ty2 : '',
        isWaitingForConnector: isWaitingForConnector,
        apiKeyData: apiKey
      })),
      status: !connector.status || connector.status === _searchConnectors.ConnectorStatus.CREATED ? 'incomplete' : 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.runConnector.title', {
        defaultMessage: 'Run connector service'
      }),
      titleSize: 'xs'
    }, {
      children: isWaitingForConnector ? /*#__PURE__*/_react.default.createElement(_waiting_for_connector_step.WaitingForConnectorStep, {
        isLoading: isLoading,
        isRecheckDisabled: !index,
        recheck: () => fetchConnector({
          connectorId: connector.id
        })
      }) : /*#__PURE__*/_react.default.createElement(_connector_linked.ConnectorLinked, null),
      status: isWaitingForConnector ? 'loading' : 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.waitingForConnector.title', {
        defaultMessage: 'Waiting for your connector'
      }),
      titleSize: 'xs'
    }]
  })))));
};
exports.ConnectorDeployment = ConnectorDeployment;