"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let promise;
const getValidationPromiseResolvers = () => {
  const resolvers = {
    rej: () => {},
    res: () => {}
  };
  promise = new Promise((resolve, reject) => {
    resolvers.res = resolve;
    resolvers.rej = reject;
  });
  return resolvers;
};
const ConnectorNameAndDescription = ({
  connector
}) => {
  const [resolverObject, setResolverObject] = (0, _react.useState)({
    rej: () => {},
    res: () => {}
  });
  const [connectorName, setConnectorName] = (0, _react.useState)(connector.name);
  const [connectorDescription, setConnectorDescription] = (0, _react.useState)(connector.description);
  const [nameErrors, setNameErrors] = (0, _react.useState)([]);
  const {
    saveNameAndDescription,
    setConnector
  } = (0, _kea.useActions)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  const {
    status,
    isLoading,
    isFailed,
    isSuccess
  } = (0, _kea.useValues)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  (0, _react.useEffect)(() => {
    setConnector(connector);
  }, [connector]);
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      resolverObject.res(true);
    }
    if (isFailed) {
      resolverObject.rej();
    }
  }, [status]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditTitle, {
    heading: "h1",
    inputAriaLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.nameAndDescription.name.ariaLabel', {
      defaultMessage: 'Edit connector name'
    }),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.nameAndDescription.name.placeholder', {
      defaultMessage: 'Add a name to your connector'
    }),
    value: connectorName,
    isLoading: isLoading,
    isInvalid: nameErrors.length > 0,
    size: "m",
    editModeProps: {
      formRowProps: {
        error: nameErrors
      },
      cancelButtonProps: {
        onClick: () => setNameErrors([])
      },
      inputProps: {
        readOnly: isLoading
      }
    },
    onSave: inputValue => {
      if (inputValue.trim().length <= 0) {
        setNameErrors([_i18n.i18n.translate('xpack.enterpriseSearch.content.nameAndDescription.name.error.empty', {
          defaultMessage: 'Connector name cannot be empty'
        })]);
        return false;
      }
      setConnectorName(inputValue);
      saveNameAndDescription({
        description: connectorDescription,
        name: inputValue
      });
      setResolverObject(getValidationPromiseResolvers());
      return promise;
    },
    onChange: event => {
      setConnectorName(event.target.value);
    },
    onCancel: previousValue => {
      setConnectorName(previousValue);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    isLoading: isLoading,
    inputAriaLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.nameAndDescription.description.ariaLabel', {
      defaultMessage: 'Edit connector description'
    }),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.nameAndDescription.description.placeholder', {
      defaultMessage: 'Add a description'
    }),
    value: connectorDescription || '',
    onSave: inputValue => {
      setConnectorDescription(inputValue);
      saveNameAndDescription({
        description: inputValue,
        name: connectorName
      });
      setResolverObject(getValidationPromiseResolvers());
      return promise;
    },
    onChange: event => {
      setConnectorDescription(event.target.value);
    },
    onCancel: previousValue => {
      setConnectorDescription(previousValue);
    }
  })));
};
exports.ConnectorNameAndDescription = ConnectorNameAndDescription;