"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDetailTabId = exports.ConnectorDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _connectors = require("../connectors/connectors");
var _page_template = require("../layout/page_template");
var _connector_scheduling = require("../search_index/connector/connector_scheduling");
var _connector_rules = require("../search_index/connector/sync_rules/connector_rules");
var _documents = require("../search_index/documents");
var _index_mappings = require("../search_index/index_mappings");
var _pipelines = require("../search_index/pipelines/pipelines");
var _header_actions = require("../shared/header_actions/header_actions");
var _connector_configuration = require("./connector_configuration");
var _connector_name_and_description = require("./connector_name_and_description");
var _connector_view_logic = require("./connector_view_logic");
var _overview = require("./overview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ConnectorDetailTabId = exports.ConnectorDetailTabId = /*#__PURE__*/function (ConnectorDetailTabId) {
  ConnectorDetailTabId["OVERVIEW"] = "overview";
  ConnectorDetailTabId["DOCUMENTS"] = "documents";
  ConnectorDetailTabId["INDEX_MAPPINGS"] = "index_mappings";
  ConnectorDetailTabId["PIPELINES"] = "pipelines";
  ConnectorDetailTabId["CONFIGURATION"] = "configuration";
  ConnectorDetailTabId["SYNC_RULES"] = "sync_rules";
  ConnectorDetailTabId["SCHEDULING"] = "scheduling";
  return ConnectorDetailTabId;
}({});
const ConnectorDetail = () => {
  var _connector$name;
  const connectorId = decodeURIComponent((0, _reactRouterDom.useParams)().connectorId);
  const {
    hasFilteringFeature,
    isLoading,
    index,
    connector
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    fetchConnectorApiReset,
    startConnectorPoll,
    stopConnectorPoll
  } = (0, _kea.useActions)(_connector_view_logic.ConnectorViewLogic);
  (0, _react.useEffect)(() => {
    stopConnectorPoll();
    fetchConnectorApiReset();
    startConnectorPoll(connectorId);
  }, [connectorId]);
  const {
    tabId = ConnectorDetailTabId.OVERVIEW
  } = (0, _reactRouterDom.useParams)();
  const {
    guidedOnboarding,
    productFeatures: {
      hasDefaultIngestPipeline
    }
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useEffect)(() => {
    var _guidedOnboarding$gui;
    const subscription = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui === void 0 ? void 0 : _guidedOnboarding$gui.isGuideStepActive$('databaseSearch', 'add_data').subscribe(isStepActive => {
      if (isStepActive && index !== null && index !== void 0 && index.count) {
        var _guidedOnboarding$gui2;
        (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.completeGuideStep('databaseSearch', 'add_data');
      }
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [guidedOnboarding, index === null || index === void 0 ? void 0 : index.count]);
  const ALL_INDICES_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_overview.ConnectorDetailOverview, null),
    id: ConnectorDetailTabId.OVERVIEW,
    isSelected: tabId === ConnectorDetailTabId.OVERVIEW,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.overviewTabLabel', {
      defaultMessage: 'Overview'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.OVERVIEW
    }))
  }, {
    content: /*#__PURE__*/_react.default.createElement(_documents.SearchIndexDocuments, null),
    disabled: !index,
    id: ConnectorDetailTabId.DOCUMENTS,
    isSelected: tabId === ConnectorDetailTabId.DOCUMENTS,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.documentsTabLabel', {
      defaultMessage: 'Documents'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.DOCUMENTS
    }))
  }, {
    content: /*#__PURE__*/_react.default.createElement(_index_mappings.SearchIndexIndexMappings, null),
    disabled: !index,
    id: ConnectorDetailTabId.INDEX_MAPPINGS,
    isSelected: tabId === ConnectorDetailTabId.INDEX_MAPPINGS,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.indexMappingsTabLabel', {
      defaultMessage: 'Index mappings'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.INDEX_MAPPINGS
    }))
  }];
  const CONNECTOR_TABS = [...(hasFilteringFeature ? [{
    content: /*#__PURE__*/_react.default.createElement(_connector_rules.ConnectorSyncRules, null),
    disabled: !index,
    id: ConnectorDetailTabId.SYNC_RULES,
    isSelected: tabId === ConnectorDetailTabId.SYNC_RULES,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.syncRulesTabLabel', {
      defaultMessage: 'Sync rules'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.SYNC_RULES
    }))
  }] : []), {
    content: /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorScheduling, null),
    disabled: !(connector !== null && connector !== void 0 && connector.index_name),
    id: ConnectorDetailTabId.SCHEDULING,
    isSelected: tabId === ConnectorDetailTabId.SCHEDULING,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.schedulingTabLabel', {
      defaultMessage: 'Scheduling'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.SCHEDULING
    }))
  }];
  const CONFIG_TAB = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfiguration, null),
    id: ConnectorDetailTabId.CONFIGURATION,
    isSelected: tabId === ConnectorDetailTabId.CONFIGURATION,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.configurationTabLabel', {
      defaultMessage: 'Configuration'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.CONFIGURATION
    }))
  }];
  const PIPELINES_TAB = {
    content: /*#__PURE__*/_react.default.createElement(_pipelines.SearchIndexPipelines, null),
    disabled: !index,
    id: ConnectorDetailTabId.PIPELINES,
    isSelected: tabId === ConnectorDetailTabId.PIPELINES,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorDetail.pipelinesTabLabel', {
      defaultMessage: 'Pipelines'
    }),
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId,
      tabId: ConnectorDetailTabId.PIPELINES
    }))
  };
  const tabs = [...ALL_INDICES_TABS, ...CONNECTOR_TABS, ...(hasDefaultIngestPipeline ? [PIPELINES_TAB] : []), ...CONFIG_TAB];
  const selectedTab = (0, _react.useMemo)(() => tabs.find(tab => tab.id === tabId), [tabId]);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._connectors.connectorsBreadcrumbs, (_connector$name = connector === null || connector === void 0 ? void 0 : connector.name) !== null && _connector$name !== void 0 ? _connector$name : '...'],
    pageViewTelemetry: tabId,
    isLoading: isLoading,
    pageHeader: {
      pageTitle: connector ? /*#__PURE__*/_react.default.createElement(_connector_name_and_description.ConnectorNameAndDescription, {
        connector: connector
      }) : '...',
      rightSideGroupProps: {
        gutterSize: 's',
        responsive: false,
        wrap: false
      },
      rightSideItems: (0, _header_actions.getHeaderActions)(index, connector),
      tabs
    }
  }, (selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.content) || null);
};
exports.ConnectorDetail = ConnectorDetail;