"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _api = require("../../../../../common/types/api");
var _doc_links = require("../../../shared/doc_links");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _connector_helpers = require("../../utils/connector_helpers");
var _connector_filtering_logic = require("../search_index/connector/sync_rules/connector_filtering_logic");
var _index_view_logic = require("../search_index/index_view_logic");
var _attach_index_box = require("./attach_index_box");
var _advanced_config_override_callout = require("./components/advanced_config_override_callout");
var _configuration_skeleton = require("./components/configuration_skeleton");
var _example_config_callout = require("./components/example_config_callout");
var _whats_next_box = require("./components/whats_next_box");
var _connector_view_logic = require("./connector_view_logic");
var _deployment = require("./deployment");
var _native_connector_configuration = require("./native_connector_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfiguration = () => {
  var _connector$service_ty, _nativeConnector$name;
  const {
    connector,
    updateConnectorConfigurationStatus
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    connectorTypes: connectors
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    isSyncing,
    isWaitingForSync
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    advancedSnippet
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const NATIVE_CONNECTORS = (0, _react.useMemo)(() => connectors.filter(({
    isNative
  }) => isNative), [connectors]);
  const {
    updateConnectorConfiguration
  } = (0, _kea.useActions)(_connector_view_logic.ConnectorViewLogic);
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (connector.is_native && connector.service_type) {
    return /*#__PURE__*/_react.default.createElement(_native_connector_configuration.NativeConnectorConfiguration, null);
  }
  const isWaitingForConnector = !connector.status || connector.status === _searchConnectors.ConnectorStatus.CREATED;
  const nativeConnector = NATIVE_CONNECTORS.find(connectorDefinition => connectorDefinition.serviceType === connector.service_type) || {
    docsUrl: '',
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    iconPath: 'custom.svg',
    isBeta: true,
    isNative: false,
    keywords: [],
    name: connector.name,
    serviceType: (_connector$service_ty = connector.service_type) !== null && _connector$service_ty !== void 0 ? _connector$service_ty : ''
  };
  const iconPath = nativeConnector.iconPath;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null,
  // TODO remove this callout when example status is removed
  (0, _connector_helpers.isExampleConnector)(connector) && /*#__PURE__*/_react.default.createElement(_example_config_callout.ExampleConfigCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    alignItems: "center"
  }, iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: iconPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, (_nativeConnector$name = nativeConnector === null || nativeConnector === void 0 ? void 0 : nativeConnector.name) !== null && _nativeConnector$name !== void 0 ? _nativeConnector$name : connector.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, connector.is_native ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.badgeType.nativeConnector', {
    defaultMessage: 'Native connector'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.badgeType.connectorClient', {
    defaultMessage: 'Connector client'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_attach_index_box.AttachIndexBox, {
    connector: connector
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deployment.ConnectorDeployment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.configuration.title', {
    defaultMessage: 'Configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isWaitingForConnector,
    loadingContent: /*#__PURE__*/_react.default.createElement(_configuration_skeleton.ConfigurationSkeleton, null),
    loadedContent: /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorConfigurationComponent, {
      connector: connector,
      hasPlatinumLicense: hasPlatinumLicense,
      isLoading: updateConnectorConfigurationStatus === _api.Status.LOADING,
      saveConfig: configuration => updateConnectorConfiguration({
        configuration,
        connectorId: connector.id
      }),
      subscriptionLink: _doc_links.docLinks.licenseManagement,
      stackManagementLink: http.basePath.prepend('/app/management/stack/license_management')
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), (0, _connector_helpers.hasNonEmptyAdvancedSnippet)(connector, advancedSnippet) && /*#__PURE__*/_react.default.createElement(_advanced_config_override_callout.AdvancedConfigOverrideCallout, null))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_whats_next_box.WhatsNextBox, {
    connectorId: connector.id,
    disabled: isWaitingForConnector || !connector.last_synced,
    isWaitingForConnector: isWaitingForConnector,
    connectorIndex: connector.index_name,
    connectorStatus: connector.status,
    isSyncing: Boolean(isSyncing || isWaitingForSync)
  })))));
};
exports.ConnectorConfiguration = ConnectorConfiguration;