"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DockerInstructionsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchApiPanels = require("@kbn/search-api-panels");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _constants = require("../../search_index/connector/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DockerInstructionsStep = ({
  connectorId,
  isWaitingForConnector,
  serviceType,
  apiKeyData
}) => {
  const [isOpen, setIsOpen] = _react.default.useState('open');
  const {
    elasticsearchUrl
  } = (0, _cloud_details.useCloudDetails)();
  (0, _react.useEffect)(() => {
    if (!isWaitingForConnector) {
      setIsOpen('closed');
    }
  }, [isWaitingForConnector]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "collapsibleDocker",
    onToggle: () => setIsOpen(isOpen === 'closed' ? 'open' : 'closed'),
    forceState: isOpen,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.downloadConfigurationLabel', {
      defaultMessage: 'You can either download the configuration file manually or run the following command'
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: 'curl https://raw.githubusercontent.com/elastic/connectors/main/config.yml.example --output </absolute/path/to>/connectors'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorDeployment.p.changeOutputPathLabel",
    defaultMessage: "Change the {output} argument value to the path where you want to save the configuration file.",
    values: {
      output: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "--output")
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorDeployment.p.editConfigYamlLabel",
    defaultMessage: "Edit the {configYaml} file and provide the next credentials",
    values: {
      configYaml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "config.yml")
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "yaml",
    codeSnippet: (0, _constants.getConnectorTemplate)({
      apiKeyData,
      connectorData: {
        id: connectorId !== null && connectorId !== void 0 ? connectorId : '',
        service_type: serviceType !== null && serviceType !== void 0 ? serviceType : ''
      },
      host: elasticsearchUrl
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.runTheFollowingCommandLabel', {
    defaultMessage: 'Run the following command in your terminal. Make sure you have Docker installed on your machine'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: (0, _constants.getRunFromDockerSnippet)({
      version: '8.15.0'
    })
  })));
};
exports.DockerInstructionsStep = DockerInstructionsStep;