"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConnector = exports.DeleteConnectorApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteConnector = async ({
  connectorId,
  shouldDeleteIndex = false
}) => {
  return await _http.HttpLogic.values.http.delete(`/internal/enterprise_search/connectors/${connectorId}`, {
    query: {
      shouldDeleteIndex
    }
  });
};
exports.deleteConnector = deleteConnector;
const DeleteConnectorApiLogic = exports.DeleteConnectorApiLogic = (0, _create_api_logic.createApiLogic)(['delete_connector_api_logic'], deleteConnector);