"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchGuide = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fetch_api_keys_logic = require("../../../enterprise_search_overview/api/fetch_api_keys_logic");
var _create_api_key_flyout = require("../../../shared/api_key/create_api_key_flyout");
var _cloud_details = require("../../../shared/cloud_details/cloud_details");
var _getting_started = require("../../../shared/getting_started/getting_started");
var _kibana = require("../../../shared/kibana");
var _layout = require("../layout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchGuide = () => {
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const {
    esConfig
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const codeArgs = {
    apiKey: '',
    cloudId: cloudContext.cloudId,
    url: esConfig.elasticsearch_host
  };
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_api_keys_logic.FetchApiKeysAPILogic);
  const {
    data
  } = (0, _kea.useValues)(_fetch_api_keys_logic.FetchApiKeysAPILogic);
  const apiKeys = (data === null || data === void 0 ? void 0 : data.api_keys) || [];
  (0, _react.useEffect)(() => makeRequest({}), []);
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchElasticsearchPageTemplate, null, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_api_key_flyout.CreateApiKeyFlyout, {
    onClose: () => setIsFlyoutOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "elasticsearchGuide"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.gettingStarted.pageTitle', {
    defaultMessage: 'Elasticsearch language clients'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.gettingStarted.pageDescription', {
    defaultMessage: "Set up your programming language client, ingest some data, and you'll be ready to start searching within minutes."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_getting_started.GettingStarted, {
    apiKeys: apiKeys,
    openApiKeyModal: () => setIsFlyoutOpen(true),
    codeArgs: codeArgs,
    isPanelLeft: true,
    showPipelinesPanel: true
  }));
};
exports.ElasticsearchGuide = ElasticsearchGuide;