"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateSearchApplicationApiKeyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _generate_search_application_api_key_logic = require("../../../../api/search_applications/generate_search_application_api_key_logic");
var _generate_search_application_api_key_modal = require("./generate_search_application_api_key_modal.logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateSearchApplicationApiKeyModal = ({
  onClose,
  searchApplicationName
}) => {
  const {
    keyName,
    apiKey,
    isLoading,
    isSuccess
  } = (0, _kea.useValues)(_generate_search_application_api_key_modal.GenerateApiKeyModalLogic);
  const {
    setKeyName
  } = (0, _kea.useActions)(_generate_search_application_api_key_modal.GenerateApiKeyModalLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_generate_search_application_api_key_logic.GenerateSearchApplicationApiKeyLogic);
  (0, _react.useEffect)(() => {
    setKeyName(`${searchApplicationName} read-only API key`);
  }, [searchApplicationName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplication.searchApplication.api.generateApiKeyModal.title', {
    defaultMessage: 'Create Search application read-only API Key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexEnd"
  }, !isSuccess ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Name your API key",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-telemetry-id": "entSearchApplications-api-generateSearchApplicationApiKeyModal-editName",
    fullWidth: true,
    placeholder: "Type a name for your API key",
    onChange: event => setKeyName(event.currentTarget.value),
    value: keyName,
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchApplications-api-generateSearchApplicationApiKeyModal-generateApiKeyButton",
    "data-test-subj": "generateApiKeyButton",
    iconSide: "left",
    iconType: "plusInCircle",
    fill: true,
    onClick: () => {
      makeRequest({
        keyName: keyName.trim(),
        searchApplicationName
      });
    },
    disabled: keyName.trim().length <= 0
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplication.searchApplication.api.generateApiKeyModal.generateButton', {
    defaultMessage: 'Generate read-only key'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, keyName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": keyName,
    fontSize: "m",
    paddingSize: "m",
    color: "dark",
    isCopyable: true
  }, apiKey)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-telemetry-id": "entSearchApplications-api-generateSearchApplicationApiKeyModal-csvDownloadButton",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.searchApplication.searchApplication.api.generateApiKeyModal.csvDownloadButton', {
      defaultMessage: 'Download API key'
    }),
    iconType: "download",
    href: encodeURI(`data:text/csv;charset=utf-8,${apiKey}`),
    download: `${keyName}.csv`
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "#006bb8"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplication.searchApplication.api.generateApiKeyModal.apiKeyWarning', {
    defaultMessage: "Elastic does not store API keys. Once generated, you'll only be able to view the key one time. Make sure you save it somewhere secure. If you lose access to it you'll need to generate a new API key from this screen."
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, apiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchApplications-api-generateSearchApplicationApiKeyModal-done",
    fill: true,
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplication.searchApplication.api.generateApiKeyModal.done', {
    defaultMessage: 'Done'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchApplications-api-generateSearchApplicationApiKeyModal-cancel",
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplication.searchApplication.api.generateApiKeyModal.cancel', {
    defaultMessage: 'Cancel'
  }))));
};
exports.GenerateSearchApplicationApiKeyModal = GenerateSearchApplicationApiKeyModal;