"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSourceEnginesModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../shared/constants");
var _i18n = require("../i18n");
var _source_engines_logic = require("../source_engines_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSourceEnginesModal = () => {
  const {
    addSourceEngines,
    closeModal,
    onAddEnginesSelection
  } = (0, _kea.useActions)(_source_engines_logic.SourceEnginesLogic);
  const {
    selectableEngineNames,
    selectedEngineNamesToAdd,
    modalLoading
  } = (0, _kea.useValues)(_source_engines_logic.SourceEnginesLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.ADD_SOURCE_ENGINES_MODAL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.ADD_SOURCE_ENGINES_MODAL_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: selectableEngineNames.map(engineName => ({
      label: engineName
    })),
    selectedOptions: selectedEngineNamesToAdd.map(engineName => ({
      label: engineName
    })),
    onChange: options => onAddEnginesSelection(options.map(option => option.label)),
    placeholder: _i18n.ADD_SOURCE_ENGINES_PLACEHOLDER
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: selectedEngineNamesToAdd.length === 0,
    isLoading: modalLoading,
    onClick: () => addSourceEngines(selectedEngineNamesToAdd),
    fill: true
  }, _constants.SAVE_BUTTON_LABEL)));
};
exports.AddSourceEnginesModal = AddSourceEnginesModal;