"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrecisionSlider = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _routes = require("../../../../routes");
var _relevance_tuning_logic = require("../../relevance_tuning_logic");
var _constants = require("./constants");
require("./precision_slider.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrecisionSlider = () => {
  const {
    searchSettings: {
      precision
    }
  } = (0, _kea.useValues)(_relevance_tuning_logic.RelevanceTuningLogic);
  const {
    setPrecision
  } = (0, _kea.useActions)(_relevance_tuning_logic.RelevanceTuningLogic);
  const stepDescription = _constants.STEP_DESCRIPTIONS[precision];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.precisionSlider.title', {
    defaultMessage: 'Precision tuning'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.precisionSlider.description', {
    defaultMessage: 'Fine tune the precision vs. recall settings on your engine.'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "documentationLink",
    href: _routes.PRECISION_DOCS_URL,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.precisionSlider.learnMore.link', {
    defaultMessage: 'Learn more.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    "aria-hidden": true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.precisionSlider.recall.label', {
    defaultMessage: 'Recall'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.precisionSlider.precision.label', {
    defaultMessage: 'Precision'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.precisionSlider.ariaLabel', {
      defaultMessage: 'Recall vs. precision'
    }),
    "data-test-subj": "PrecisionRange",
    value: precision,
    onChange: e => {
      setPrecision(parseInt(e.target.value, 10));
    },
    min: 1,
    max: 11,
    step: 1,
    showRange: true,
    showTicks: true,
    fullWidth: true
  }), stepDescription && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "stepDescription",
    color: "subdued",
    "data-test-subj": "StepDescription"
  }, stepDescription)));
};
exports.PrecisionSlider = PrecisionSlider;