"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuditLogsModalLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuditLogsModalLogic = exports.AuditLogsModalLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'engines_overview', 'audit_logs_modal'],
  actions: () => ({
    hideModal: true,
    showModal: engineName => ({
      engineName
    })
  }),
  reducers: () => ({
    isModalVisible: [false, {
      showModal: () => true,
      hideModal: () => false
    }],
    engineName: ['', {
      showModal: (_, {
        engineName
      }) => engineName,
      hideModal: () => ''
    }]
  })
});