"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeader = exports.FlyoutFooter = exports.FlyoutBody = exports.ApiCodeExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _enterprise_search_url = require("../../../../shared/enterprise_search_url");
var _routes = require("../../../routes");
var _engine = require("../../engine");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiCodeExample = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutHeader, null), /*#__PURE__*/_react.default.createElement(FlyoutBody, null), /*#__PURE__*/_react.default.createElement(FlyoutFooter, null));
exports.ApiCodeExample = ApiCodeExample;
const FlyoutHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: _constants2.FLYOUT_ARIA_LABEL_ID
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.api.title', {
    defaultMessage: 'Indexing by API'
  }))));
};
exports.FlyoutHeader = FlyoutHeader;
const FlyoutBody = () => {
  const {
    engineName,
    engine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const {
    apiKey
  } = engine;
  const documentsApiUrl = (0, _enterprise_search_url.getEnterpriseSearchUrl)(`/api/as/v1/engines/${engineName}/documents`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.documentCreation.api.description",
    defaultMessage: "The {documentsApiLink} can be used to add new documents to your engine, update documents, retrieve documents by id, and delete documents. There are a variety of {clientLibrariesLink} to help you get started.",
    values: {
      documentsApiLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _routes.INDEXING_DOCS_URL
      }, "documents API"),
      clientLibrariesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: _routes.API_CLIENTS_DOCS_URL
      }, "client libraries")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.api.example', {
    defaultMessage: 'To see the API in action, you can experiment with the example request below using a command line or a client library.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    className: "eui-textBreakAll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, "POST")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true
  }, documentsApiUrl)))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    fontSize: "m",
    isCopyable: true
  }, `\
curl -X POST '${documentsApiUrl}' \\
  -H 'Content-Type: application/json' \\
  -H 'Authorization: Bearer ${apiKey}' \\
  -d '${_constants2.DOCUMENTS_API_JSON_EXAMPLE}'
# Returns
# [
#   {
#     "id": "park_rocky-mountain",
#     "errors": []
#   },
#   {
#     "id": "park_saguaro",
#     "errors": []
#   }
# ]`));
};
exports.FlyoutBody = FlyoutBody;
const FlyoutFooter = () => {
  const {
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDocumentCreation
  }, _constants.CANCEL_BUTTON_LABEL));
};
exports.FlyoutFooter = FlyoutFooter;