"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.crawlConfigServerToClient = crawlConfigServerToClient;
exports.crawlDomainValidationToResult = crawlDomainValidationToResult;
exports.crawlEventServerToClient = crawlEventServerToClient;
exports.crawlRequestServerToClient = crawlRequestServerToClient;
exports.crawlRequestStatsServerToClient = crawlRequestStatsServerToClient;
exports.crawlRequestWithDetailsServerToClient = crawlRequestWithDetailsServerToClient;
exports.crawlerDataServerToClient = crawlerDataServerToClient;
exports.crawlerDomainServerToClient = crawlerDomainServerToClient;
exports.getDeleteDomainSuccessMessage = exports.getDeleteDomainConfirmationMessage = exports.getCrawlRulePathPatternTooltip = exports.domainConfigServerToClient = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function crawlerDomainServerToClient(payload) {
  const {
    id,
    name,
    sitemaps,
    created_on: createdOn,
    last_visited_at: lastCrawl,
    document_count: documentCount,
    crawl_rules: crawlRules,
    default_crawl_rule: defaultCrawlRule,
    entry_points: entryPoints,
    deduplication_enabled: deduplicationEnabled,
    deduplication_fields: deduplicationFields,
    available_deduplication_fields: availableDeduplicationFields
  } = payload;
  const clientPayload = {
    id,
    url: name,
    documentCount,
    createdOn,
    crawlRules,
    sitemaps,
    entryPoints,
    deduplicationEnabled,
    deduplicationFields,
    availableDeduplicationFields
  };
  if (lastCrawl) {
    clientPayload.lastCrawl = lastCrawl;
  }
  if (defaultCrawlRule) {
    clientPayload.defaultCrawlRule = defaultCrawlRule;
  }
  return clientPayload;
}
function crawlRequestStatsServerToClient(crawlStats) {
  const {
    status: {
      avg_response_time_msec: avgResponseTimeMSec,
      crawl_duration_msec: crawlDurationMSec,
      pages_visited: pagesVisited,
      urls_allowed: urlsAllowed,
      status_codes: statusCodes
    }
  } = crawlStats;
  return {
    status: {
      urlsAllowed,
      pagesVisited,
      avgResponseTimeMSec,
      crawlDurationMSec,
      statusCodes
    }
  };
}
function crawlRequestServerToClient(crawlRequest) {
  const {
    id,
    status,
    created_at: createdAt,
    began_at: beganAt,
    completed_at: completedAt
  } = crawlRequest;
  return {
    id,
    status,
    createdAt,
    beganAt,
    completedAt
  };
}
function crawlConfigServerToClient(crawlConfig) {
  const {
    domain_allowlist: domainAllowlist,
    seed_urls: seedUrls,
    sitemap_urls: sitemapUrls,
    max_crawl_depth: maxCrawlDepth
  } = crawlConfig;
  return {
    domainAllowlist,
    seedUrls,
    sitemapUrls,
    maxCrawlDepth
  };
}
function crawlEventServerToClient(event) {
  const {
    id,
    stage,
    status,
    created_at: createdAt,
    began_at: beganAt,
    completed_at: completedAt,
    type,
    crawl_config: crawlConfig
  } = event;
  return {
    id,
    stage,
    status,
    createdAt,
    beganAt,
    completedAt,
    type,
    crawlConfig: crawlConfigServerToClient(crawlConfig)
  };
}
function crawlRequestWithDetailsServerToClient(event) {
  const {
    began_at: beganAt,
    completed_at: completedAt,
    crawl_config: crawlConfig,
    created_at: createdAt,
    id,
    stats: crawlStats,
    status,
    type
  } = event;
  return {
    beganAt,
    completedAt,
    crawlConfig: crawlConfigServerToClient(crawlConfig),
    createdAt,
    id,
    stats: crawlStats && crawlRequestStatsServerToClient(crawlStats),
    status,
    type
  };
}
function crawlerDataServerToClient(payload) {
  const {
    domains,
    events,
    most_recent_crawl_request: mostRecentCrawlRequest
  } = payload;
  return {
    domains: domains.map(domain => crawlerDomainServerToClient(domain)),
    events: events.map(event => crawlEventServerToClient(event)),
    mostRecentCrawlRequest: mostRecentCrawlRequest && crawlRequestServerToClient(mostRecentCrawlRequest)
  };
}
function crawlDomainValidationToResult(data) {
  if (!data.valid) {
    var _data$results$find;
    return {
      state: 'invalid',
      blockingFailure: true,
      message: (_data$results$find = data.results.find(result => result.result === 'failure')) === null || _data$results$find === void 0 ? void 0 : _data$results$find.comment
    };
  }
  const warningResult = data.results.find(result => result.result === 'warning');
  if (warningResult) {
    return {
      state: 'warning',
      blockingFailure: !data.valid,
      message: warningResult.comment
    };
  }
  return {
    state: 'valid'
  };
}
const getDeleteDomainConfirmationMessage = domainUrl => {
  return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.action.deleteDomain.confirmationPopupMessage', {
    defaultMessage: 'Are you sure you want to remove the domain "{domainUrl}" and all of its settings?',
    values: {
      domainUrl
    }
  });
};
exports.getDeleteDomainConfirmationMessage = getDeleteDomainConfirmationMessage;
const getDeleteDomainSuccessMessage = domainUrl => {
  return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.action.deleteDomain.successMessage', {
    defaultMessage: "Domain ''{domainUrl}'' was deleted",
    values: {
      domainUrl
    }
  });
};
exports.getDeleteDomainSuccessMessage = getDeleteDomainSuccessMessage;
const getCrawlRulePathPatternTooltip = crawlRule => {
  if (crawlRule.rule === _types.CrawlerRules.regex) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.regexPathPatternTooltip', {
      defaultMessage: 'The path pattern is a regular expression compatible with the Ruby language regular expression engine.'
    });
  }
  return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesTable.pathPatternTooltip', {
    defaultMessage: 'The path pattern is a literal string except for the asterisk (*) character, which is a meta character that will match anything.'
  });
};
exports.getCrawlRulePathPatternTooltip = getCrawlRulePathPatternTooltip;
const domainConfigServerToClient = domainConfigFromServer => ({
  id: domainConfigFromServer.id,
  name: domainConfigFromServer.name,
  seedUrls: domainConfigFromServer.seed_urls,
  sitemapUrls: domainConfigFromServer.sitemap_urls
});
exports.domainConfigServerToClient = domainConfigServerToClient;