"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionIntegrateView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
var _page_template = require("../../layout/page_template");
var _analytics_collection_integrate_javascript_client_embed = require("./analytics_collection_integrate_javascript_client_embed");
var _analytics_collection_integrate_javascript_embed = require("./analytics_collection_integrate_javascript_embed");
var _analytics_collection_integrate_searchui = require("./analytics_collection_integrate_searchui");
var _generate_analytics_api_key_modal = require("./api_key_modal/generate_analytics_api_key_modal");
var _generate_analytics_api_key_modal2 = require("./api_key_modal/generate_analytics_api_key_modal.logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CORSStep = () => ({
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.corsStep.title', {
    defaultMessage: 'Configure CORS'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.corsStep.description', {
    defaultMessage: "You must configure CORS to allow requests from your website's domain to the Analytics API endpoint. You can do this by adding the following to your Elasticsearch configuration file:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true
  }, `# http.cors.allow-origin: "https://my-website-domain.example"
http.cors.allow-origin: "*"
http.cors.enabled: true
http.cors.allow-credentials: true
http.cors.allow-methods: OPTIONS, POST
http.cors.allow-headers: X-Requested-With, X-Auth-Token, Content-Type, Content-Length, Authorization, Access-Control-Allow-Headers, Accept`), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.corsStep.descriptionTwo', {
    defaultMessage: "Alternatively you can use a proxy server to route analytic requests from your website's domain to the Analytics API endpoint which will allow you to avoid configuring CORS."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.behavioralAnalyticsCORS,
    "data-telemetry-id": "entSearchContent-analytics-cors-learnMoreLink",
    external: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.corsStep.learnMoreLink', {
    defaultMessage: 'Learn more about CORS for Behavioral Analytics.'
  })))))
});
const apiKeyStep = (openApiKeyModal, navigateToUrl) => ({
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.apiKey.title', {
    defaultMessage: 'Create an API Key'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.apiKeyStep.apiKeyWarning', {
    defaultMessage: "Elastic does not store API keys. Once generated, you'll only be able to view the key one time. Make sure you save it somewhere secure. If you lose access to it you'll need to generate a new API key from this screen."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.apiKeys,
    "data-telemetry-id": "entSearchContent-analytics-apiKey-learnMoreLink",
    external: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.apiKeyStep.learnMoreLink', {
    defaultMessage: 'Learn more about API keys.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconSide: "left",
    iconType: "plusInCircleFilled",
    onClick: openApiKeyModal,
    "data-telemetry-id": "entSearchContent-analytics-apiKey-createApiKeyButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.apiKeyStep.createAPIKeyButton', {
    defaultMessage: 'Create API Key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconSide: "left",
    iconType: "popout",
    "data-telemetry-id": "entSearchContent-analytics-apiKey-viewKeysButton",
    onClick: () => navigateToUrl('/app/management/security/api_keys', {
      shouldNotCreateHref: true
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.apiKeyStep.viewKeysButton', {
    defaultMessage: 'View Keys'
  })))))
});
const AnalyticsCollectionIntegrateView = ({
  analyticsCollection
}) => {
  const [selectedTab, setSelectedTab] = (0, _react.useState)('javascriptEmbed');
  const [apiKeyModelOpen, setApiKeyModalOpen] = (0, _react.useState)(false);
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    apiKey
  } = (0, _kea.useValues)(_generate_analytics_api_key_modal2.GenerateApiKeyModalLogic);
  const DEFAULT_URL = 'https://localhost:9200';
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const baseUrl = cloudContext.elasticsearchUrl || DEFAULT_URL;
  const analyticsConfig = {
    apiKey: apiKey || '########',
    collectionName: analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name,
    endpoint: baseUrl
  };
  const webClientSrc = `https://cdn.jsdelivr.net/npm/@elastic/behavioral-analytics-browser-tracker@2`;
  const tabs = [{
    key: 'javascriptEmbed',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.title', {
      defaultMessage: 'Javascript Embed'
    })
  }, {
    key: 'javascriptClientEmbed',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.title', {
      defaultMessage: 'Javascript Client'
    })
  }, {
    key: 'searchuiEmbed',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchuiEmbed.title', {
      defaultMessage: 'Search UI'
    })
  }];
  const apiKeyStepGuide = apiKeyStep(() => setApiKeyModalOpen(true), navigateToUrl);
  const steps = {
    javascriptClientEmbed: [apiKeyStepGuide, CORSStep(), ...(0, _analytics_collection_integrate_javascript_client_embed.javascriptClientEmbedSteps)(analyticsConfig)],
    javascriptEmbed: [apiKeyStepGuide, CORSStep(), ...(0, _analytics_collection_integrate_javascript_embed.javascriptEmbedSteps)(webClientSrc, analyticsConfig)],
    searchuiEmbed: (0, _analytics_collection_integrate_searchui.searchUIEmbedSteps)(setSelectedTab)
  };
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    restrictWidth: true,
    pageChrome: [analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name],
    analyticsName: analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name,
    pageViewTelemetry: `View Analytics Collection - integrate`,
    pageHeader: {
      bottomBorder: false,
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.title', {
        defaultMessage: 'Tracker Integration'
      }),
      description: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.integration.description', {
        defaultMessage: 'Easily install our tracker on your application or website to receive in-depth analytics data.'
      }),
      rightSideItems: []
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, apiKeyModelOpen ? /*#__PURE__*/_react.default.createElement(_generate_analytics_api_key_modal.GenerateAnalyticsApiKeyModal, {
    collectionName: analyticsCollection.name,
    onClose: () => {
      setApiKeyModalOpen(false);
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.key,
    onClick: () => {
      setSelectedTab(tab.key);
    },
    isSelected: selectedTab === tab.key,
    "data-test-subj": tab.key,
    "data-telemetry-id": `entSearch-analytics-integrate-${tab.key}-tab`
  }, tab.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps[selectedTab]
  })));
};
exports.AnalyticsCollectionIntegrateView = AnalyticsCollectionIntegrateView;