"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.input = void 0;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const input = exports.input = (0, _toolkit.createSlice)({
  name: 'input',
  initialState: {},
  reducers: {
    setDisabledActions(state, action) {
      state.disabledActions = action.payload;
    },
    setDisableTriggers(state, action) {
      state.disableTriggers = action.payload;
    },
    setEnhancements(state, action) {
      state.enhancements = action.payload;
    },
    setExecutionContext(state, action) {
      state.executionContext = action.payload;
    },
    setHidePanelTitles(state, action) {
      state.hidePanelTitles = action.payload;
    },
    setLastReloadRequestTime(state, action) {
      state.lastReloadRequestTime = action.payload;
    },
    setSearchSessionId(state, action) {
      state.searchSessionId = action.payload;
    },
    setSyncColors(state, action) {
      state.syncColors = action.payload;
    },
    setSyncCursor(state, action) {
      state.syncCursor = action.payload;
    },
    setSyncTooltips(state, action) {
      state.syncTooltips = action.payload;
    },
    setTitle(state, action) {
      state.title = action.payload;
    },
    setViewMode(state, action) {
      state.viewMode = action.payload;
    },
    update(state, action) {
      return {
        ...state,
        ...action.payload
      };
    }
  }
});