"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeReactEmbeddableState = void 0;
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initializeReactEmbeddableState = async (uuid, factory, parentApi) => {
  var _parentApi$getRuntime;
  const serializedState = parentApi.getSerializedStateForChild(uuid);
  const lastSavedRuntimeState = serializedState ? await factory.deserializeState(serializedState) : {};

  // If the parent provides runtime state for the child (usually as a state backup or cache),
  // we merge it with the last saved runtime state.
  const partialRuntimeState = (0, _presentationContainers.apiHasRuntimeChildState)(parentApi) ? (_parentApi$getRuntime = parentApi.getRuntimeStateForChild(uuid)) !== null && _parentApi$getRuntime !== void 0 ? _parentApi$getRuntime : {} : {};
  const initialRuntimeState = {
    ...lastSavedRuntimeState,
    ...partialRuntimeState
  };
  const startStateDiffing = comparators => {
    const subscription = new _rxjs.Subscription();
    const snapshotRuntimeState = () => {
      const comparatorKeys = Object.keys(comparators);
      return comparatorKeys.reduce((acc, key) => {
        acc[key] = comparators[key][0].value;
        return acc;
      }, {});
    };

    // the last saved state subject is always initialized with the deserialized state from the parent.
    const lastSavedState$ = new _rxjs.BehaviorSubject(lastSavedRuntimeState);
    if ((0, _presentationContainers.apiHasSaveNotification)(parentApi)) {
      subscription.add(
      // any time the parent saves, the current state becomes the last saved state...
      parentApi.saveNotification$.subscribe(() => {
        lastSavedState$.next(snapshotRuntimeState());
      }));
    }
    const comparatorSubjects = [];
    const comparatorKeys = [];
    for (const key of Object.keys(comparators)) {
      const comparatorSubject = comparators[key][0]; // 0th element of tuple is the subject
      comparatorSubjects.push(comparatorSubject);
      comparatorKeys.push(key);
    }
    const unsavedChanges = new _rxjs.BehaviorSubject((0, _presentationPublishing.runComparators)(comparators, comparatorKeys, lastSavedState$.getValue(), (0, _presentationPublishing.getInitialValuesFromComparators)(comparators, comparatorKeys)));
    subscription.add((0, _rxjs.combineLatest)(comparatorSubjects).pipe((0, _rxjs.debounceTime)(100), (0, _rxjs.map)(latestStates => comparatorKeys.reduce((acc, key, index) => {
      acc[key] = latestStates[index];
      return acc;
    }, {})), (0, _rxjs.combineLatestWith)(lastSavedState$)).subscribe(([latest, last]) => {
      unsavedChanges.next((0, _presentationPublishing.runComparators)(comparators, comparatorKeys, last, latest));
    }));
    return {
      unsavedChanges,
      resetUnsavedChanges: () => {
        const lastSaved = lastSavedState$.getValue();
        for (const key of comparatorKeys) {
          const setter = comparators[key][1]; // setter function is the 1st element of the tuple
          setter(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved[key]);
        }
      },
      snapshotRuntimeState,
      cleanup: () => subscription.unsubscribe()
    };
  };
  return {
    initialState: initialRuntimeState,
    startStateDiffing
  };
};
exports.initializeReactEmbeddableState = initializeReactEmbeddableState;