"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelloWorldContainer = exports.HELLO_WORLD_CONTAINER = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _ = require("../..");
var _hello_world_container_component = require("./hello_world_container_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const HELLO_WORLD_CONTAINER = exports.HELLO_WORLD_CONTAINER = 'HELLO_WORLD_CONTAINER';

/**
 * interfaces are not allowed to specify a sub-set of the required types until
 * https://github.com/microsoft/TypeScript/issues/15300 is fixed so we use a type
 * here instead
 */

class HelloWorldContainer extends _.Container {
  constructor(input, options, initializeSettings) {
    super(input, {
      embeddableLoaded: {}
    }, options.getEmbeddableFactory || (() => undefined), undefined, initializeSettings);
    (0, _defineProperty2.default)(this, "type", HELLO_WORLD_CONTAINER);
  }
  getInheritedInput(id) {
    return {
      id,
      viewMode: this.input.viewMode || _.ViewMode.EDIT,
      lastName: this.input.lastName || 'foo'
    };
  }
  render(node) {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_hello_world_container_component.HelloWorldContainerComponent, {
      container: this
    })), node);
  }
}
exports.HelloWorldContainer = HelloWorldContainer;